/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.statistics;

import java.io.Serializable;
import javax.annotation.Nullable;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.statistics.IOStatistics;
import oadd.org.apache.hadoop.fs.statistics.MeanStatistic;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class DurationStatisticSummary
implements Serializable {
    private static final long serialVersionUID = 6776381340896518486L;
    private final String key;
    private final boolean success;
    private final long count;
    private final long max;
    private final long min;
    private final MeanStatistic mean;

    public DurationStatisticSummary(String key, boolean success, long count, long max, long min2, @Nullable MeanStatistic mean) {
        this.key = key;
        this.success = success;
        this.count = count;
        this.max = max;
        this.min = min2;
        this.mean = mean == null ? null : mean.clone();
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getCount() {
        return this.count;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public MeanStatistic getMean() {
        return this.mean;
    }

    public String toString() {
        return "DurationStatisticSummary{key='" + this.key + '\'' + ", success=" + this.success + ", counter=" + this.count + ", max=" + this.max + ", mean=" + this.mean + '}';
    }

    public static DurationStatisticSummary fetchDurationSummary(IOStatistics source, String key, boolean success) {
        String fullkey = success ? key : key + ".failures";
        return new DurationStatisticSummary(key, success, source.counters().getOrDefault(fullkey, 0L), source.maximums().getOrDefault(fullkey + ".max", -1L), source.minimums().getOrDefault(fullkey + ".min", -1L), source.meanStatistics().get(fullkey + ".mean"));
    }

    public static DurationStatisticSummary fetchSuccessSummary(IOStatistics source, String key) {
        return DurationStatisticSummary.fetchDurationSummary(source, key, true);
    }
}

