/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.statistics;

import java.io.Serializable;
import java.util.Objects;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class MeanStatistic
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 567888327998615425L;
    private long samples;
    private long sum;

    public MeanStatistic(long samples, long sum) {
        if (samples > 0L) {
            this.sum = sum;
            this.samples = samples;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeanStatistic(MeanStatistic that) {
        MeanStatistic meanStatistic = that;
        synchronized (meanStatistic) {
            this.set(that);
        }
    }

    public MeanStatistic() {
    }

    public synchronized long getSum() {
        return this.sum;
    }

    public synchronized long getSamples() {
        return this.samples;
    }

    @JsonIgnore
    public synchronized boolean isEmpty() {
        return this.samples == 0L;
    }

    public void clear() {
        this.setSamplesAndSum(0L, 0L);
    }

    public synchronized void setSamplesAndSum(long sampleCount, long newSum) {
        this.setSamples(sampleCount);
        this.setSum(newSum);
    }

    public void set(MeanStatistic other) {
        this.setSamplesAndSum(other.getSamples(), other.getSum());
    }

    public synchronized void setSum(long sum) {
        this.sum = sum;
    }

    public synchronized void setSamples(long samples) {
        this.samples = samples < 0L ? 0L : samples;
    }

    public synchronized double mean() {
        return this.samples > 0L ? (double)this.sum / (double)this.samples : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MeanStatistic add(MeanStatistic other) {
        long otherSum;
        long otherSamples;
        if (other.isEmpty()) {
            return this;
        }
        MeanStatistic meanStatistic = other;
        synchronized (meanStatistic) {
            otherSamples = other.samples;
            otherSum = other.sum;
        }
        if (this.isEmpty()) {
            this.samples = otherSamples;
            this.sum = otherSum;
            return this;
        }
        this.samples += otherSamples;
        this.sum += otherSum;
        return this;
    }

    public synchronized void addSample(long value) {
        ++this.samples;
        this.sum += value;
    }

    public synchronized int hashCode() {
        return Objects.hash(this.sum, this.samples);
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanStatistic that = (MeanStatistic)o;
        if (this.isEmpty()) {
            return that.isEmpty();
        }
        return this.getSum() == that.getSum() && this.getSamples() == that.getSamples();
    }

    public MeanStatistic clone() {
        return this.copy();
    }

    public MeanStatistic copy() {
        return new MeanStatistic(this);
    }

    public String toString() {
        return String.format("(samples=%d, sum=%d, mean=%.4f)", this.samples, this.sum, this.mean());
    }
}

