/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.statistics.impl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import oadd.org.apache.hadoop.fs.statistics.MeanStatistic;
import oadd.org.apache.hadoop.fs.statistics.impl.AbstractIOStatisticsImpl;
import oadd.org.apache.hadoop.fs.statistics.impl.EvaluatingStatisticsMap;

final class DynamicIOStatistics
extends AbstractIOStatisticsImpl {
    private final EvaluatingStatisticsMap<Long> counters = new EvaluatingStatisticsMap();
    private final EvaluatingStatisticsMap<Long> gauges = new EvaluatingStatisticsMap();
    private final EvaluatingStatisticsMap<Long> minimums = new EvaluatingStatisticsMap();
    private final EvaluatingStatisticsMap<Long> maximums = new EvaluatingStatisticsMap();
    private final EvaluatingStatisticsMap<MeanStatistic> meanStatistics = new EvaluatingStatisticsMap<MeanStatistic>(MeanStatistic::copy);

    DynamicIOStatistics() {
    }

    @Override
    public Map<String, Long> counters() {
        return Collections.unmodifiableMap(this.counters);
    }

    @Override
    public Map<String, Long> gauges() {
        return Collections.unmodifiableMap(this.gauges);
    }

    @Override
    public Map<String, Long> minimums() {
        return Collections.unmodifiableMap(this.minimums);
    }

    @Override
    public Map<String, Long> maximums() {
        return Collections.unmodifiableMap(this.maximums);
    }

    @Override
    public Map<String, MeanStatistic> meanStatistics() {
        return Collections.unmodifiableMap(this.meanStatistics);
    }

    void addCounterFunction(String key, Function<String, Long> eval) {
        this.counters.addFunction(key, eval);
    }

    void addGaugeFunction(String key, Function<String, Long> eval) {
        this.gauges.addFunction(key, eval);
    }

    void addMinimumFunction(String key, Function<String, Long> eval) {
        this.minimums.addFunction(key, eval);
    }

    void addMaximumFunction(String key, Function<String, Long> eval) {
        this.maximums.addFunction(key, eval);
    }

    void addMeanStatisticFunction(String key, Function<String, MeanStatistic> eval) {
        this.meanStatistics.addFunction(key, eval);
    }
}

