/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.store.audit;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.store.audit.AuditSpan;
import oadd.org.apache.hadoop.util.functional.CallableRaisingIOE;
import oadd.org.apache.hadoop.util.functional.FunctionRaisingIOE;
import oadd.org.apache.hadoop.util.functional.InvocationRaisingIOE;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class AuditingFunctions {
    private AuditingFunctions() {
    }

    public static <T> CallableRaisingIOE<T> withinAuditSpan(@Nullable AuditSpan auditSpan, CallableRaisingIOE<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.apply();
        };
    }

    public static InvocationRaisingIOE withinAuditSpan(@Nullable AuditSpan auditSpan, InvocationRaisingIOE operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            operation.apply();
        };
    }

    public static <T, R> FunctionRaisingIOE<T, R> withinAuditSpan(@Nullable AuditSpan auditSpan, FunctionRaisingIOE<T, R> operation) {
        return auditSpan == null ? operation : x -> {
            auditSpan.activate();
            return operation.apply(x);
        };
    }

    public static <T> Callable<T> callableWithinAuditSpan(@Nullable AuditSpan auditSpan, Callable<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.call();
        };
    }
}

