/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.viewfs;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.viewfs.RegexMountPointInterceptor;
import oadd.org.apache.hadoop.fs.viewfs.RegexMountPointInterceptorType;
import oadd.org.apache.hadoop.fs.viewfs.RegexMountPointResolvedDstPathReplaceInterceptor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
final class RegexMountPointInterceptorFactory {
    private RegexMountPointInterceptorFactory() {
    }

    public static RegexMountPointInterceptor create(String interceptorSettingsString) {
        int typeTagIndex = interceptorSettingsString.indexOf(58);
        if (typeTagIndex == -1 || typeTagIndex == interceptorSettingsString.length() - 1) {
            return null;
        }
        String typeTag = interceptorSettingsString.substring(0, typeTagIndex).trim().toLowerCase();
        RegexMountPointInterceptorType interceptorType = RegexMountPointInterceptorType.get(typeTag);
        if (interceptorType == null) {
            return null;
        }
        switch (interceptorType) {
            case REPLACE_RESOLVED_DST_PATH: {
                RegexMountPointResolvedDstPathReplaceInterceptor interceptor = RegexMountPointResolvedDstPathReplaceInterceptor.deserializeFromString(interceptorSettingsString);
                return interceptor;
            }
        }
        return null;
    }
}

