/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oadd.org.apache.hadoop.conf.Configurable;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.compress.BlockCompressorStream;
import oadd.org.apache.hadoop.io.compress.BlockDecompressorStream;
import oadd.org.apache.hadoop.io.compress.CompressionCodec;
import oadd.org.apache.hadoop.io.compress.CompressionInputStream;
import oadd.org.apache.hadoop.io.compress.CompressionOutputStream;
import oadd.org.apache.hadoop.io.compress.Compressor;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.DirectDecompressionCodec;
import oadd.org.apache.hadoop.io.compress.DirectDecompressor;
import oadd.org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import oadd.org.apache.hadoop.io.compress.snappy.SnappyDecompressor;

public class SnappyCodec
implements Configurable,
CompressionCodec,
DirectDecompressionCodec {
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        int bufferSize = this.conf.getInt("oadd.io.compression.codec.snappy.buffersize", 262144);
        int compressionOverhead = bufferSize / 6 + 32;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return SnappyCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        int bufferSize = this.conf.getInt("oadd.io.compression.codec.snappy.buffersize", 262144);
        return new SnappyCompressor(bufferSize);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt("oadd.io.compression.codec.snappy.buffersize", 262144));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return SnappyDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        int bufferSize = this.conf.getInt("oadd.io.compression.codec.snappy.buffersize", 262144);
        return new SnappyDecompressor(bufferSize);
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return new SnappyDecompressor.SnappyDirectDecompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".snappy";
    }
}

