/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress.zlib;

import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.compress.Compressor;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.DirectDecompressor;
import oadd.org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import oadd.org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import oadd.org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import oadd.org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import oadd.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZlibFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ZlibFactory.class);
    private static boolean nativeZlibLoaded = false;

    @VisibleForTesting
    public static void loadNativeZLib() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeZlibLoaded = ZlibCompressor.isNativeZlibLoaded() && ZlibDecompressor.isNativeZlibLoaded();
            if (nativeZlibLoaded) {
                LOG.info("Successfully loaded & initialized native-zlib library");
            } else {
                LOG.warn("Failed to load/initialize native-zlib library");
            }
        }
    }

    @VisibleForTesting
    public static void setNativeZlibLoaded(boolean isLoaded) {
        nativeZlibLoaded = isLoaded;
    }

    public static boolean isNativeZlibLoaded(Configuration conf) {
        return nativeZlibLoaded;
    }

    public static String getLibraryName() {
        return ZlibCompressor.getLibraryName();
    }

    public static Class<? extends Compressor> getZlibCompressorType(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? ZlibCompressor.class : BuiltInZlibDeflater.class;
    }

    public static Compressor getZlibCompressor(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? new ZlibCompressor(conf) : new BuiltInZlibDeflater(ZlibFactory.getCompressionLevel(conf).compressionLevel());
    }

    public static Class<? extends Decompressor> getZlibDecompressorType(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? ZlibDecompressor.class : BuiltInZlibInflater.class;
    }

    public static Decompressor getZlibDecompressor(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? new ZlibDecompressor() : new BuiltInZlibInflater();
    }

    public static DirectDecompressor getZlibDirectDecompressor(Configuration conf) {
        return ZlibFactory.isNativeZlibLoaded(conf) ? new ZlibDecompressor.ZlibDirectDecompressor() : null;
    }

    public static void setCompressionStrategy(Configuration conf, ZlibCompressor.CompressionStrategy strategy) {
        conf.setEnum("zlib.compress.strategy", strategy);
    }

    public static ZlibCompressor.CompressionStrategy getCompressionStrategy(Configuration conf) {
        return conf.getEnum("zlib.compress.strategy", ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY);
    }

    public static void setCompressionLevel(Configuration conf, ZlibCompressor.CompressionLevel level) {
        conf.setEnum("zlib.compress.level", level);
    }

    public static ZlibCompressor.CompressionLevel getCompressionLevel(Configuration conf) {
        return conf.getEnum("zlib.compress.level", ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION);
    }

    static {
        ZlibFactory.loadNativeZLib();
    }
}

