/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.coder;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.CodecUtil;
import oadd.org.apache.hadoop.io.erasurecode.ECBlock;
import oadd.org.apache.hadoop.io.erasurecode.ECBlockGroup;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import oadd.org.apache.hadoop.io.erasurecode.coder.HHXORErasureDecodingStep;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureDecoder
extends ErasureDecoder {
    private RawErasureDecoder rsRawDecoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureDecoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        ECBlock[] outputBlocks = this.getOutputBlocks(blockGroup);
        RawErasureDecoder rawDecoder = this.checkCreateRSRawDecoder();
        RawErasureEncoder rawEncoder = this.checkCreateXorRawEncoder();
        return new HHXORErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), outputBlocks, rawDecoder, rawEncoder);
    }

    private RawErasureDecoder checkCreateRSRawDecoder() {
        if (this.rsRawDecoder == null) {
            this.rsRawDecoder = CodecUtil.createRawDecoder(this.getConf(), "rs", this.getOptions());
        }
        return this.rsRawDecoder;
    }

    private RawErasureEncoder checkCreateXorRawEncoder() {
        if (this.xorRawEncoder == null) {
            this.xorRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "xor", this.getOptions());
        }
        return this.xorRawEncoder;
    }

    @Override
    public boolean preferDirectBuffer() {
        return false;
    }

    @Override
    public void release() {
        if (this.rsRawDecoder != null) {
            this.rsRawDecoder.release();
        }
        if (this.xorRawEncoder != null) {
            this.xorRawEncoder.release();
        }
    }
}

