/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.coder;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.CodecUtil;
import oadd.org.apache.hadoop.io.erasurecode.ECBlock;
import oadd.org.apache.hadoop.io.erasurecode.ECBlockGroup;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import oadd.org.apache.hadoop.io.erasurecode.coder.HHXORErasureEncodingStep;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class HHXORErasureEncoder
extends ErasureEncoder {
    private RawErasureEncoder rsRawEncoder;
    private RawErasureEncoder xorRawEncoder;

    public HHXORErasureEncoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareEncodingStep(ECBlockGroup blockGroup) {
        RawErasureEncoder rsRawEncoderTmp = this.checkCreateRSRawEncoder();
        RawErasureEncoder xorRawEncoderTmp = this.checkCreateXorRawEncoder();
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new HHXORErasureEncodingStep(inputBlocks, this.getOutputBlocks(blockGroup), rsRawEncoderTmp, xorRawEncoderTmp);
    }

    private RawErasureEncoder checkCreateRSRawEncoder() {
        if (this.rsRawEncoder == null) {
            this.rsRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "rs", this.getOptions());
        }
        return this.rsRawEncoder;
    }

    private RawErasureEncoder checkCreateXorRawEncoder() {
        if (this.xorRawEncoder == null) {
            this.xorRawEncoder = CodecUtil.createRawEncoder(this.getConf(), "xor", this.getOptions());
        }
        return this.xorRawEncoder;
    }

    @Override
    public void release() {
        if (this.rsRawEncoder != null) {
            this.rsRawEncoder.release();
        }
        if (this.xorRawEncoder != null) {
            this.xorRawEncoder.release();
        }
    }
}

