/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.erasurecode.coder;

import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.io.erasurecode.CodecUtil;
import oadd.org.apache.hadoop.io.erasurecode.ECBlock;
import oadd.org.apache.hadoop.io.erasurecode.ECBlockGroup;
import oadd.org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import oadd.org.apache.hadoop.io.erasurecode.coder.ErasureDecodingStep;
import oadd.org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class RSErasureDecoder
extends ErasureDecoder {
    private RawErasureDecoder rsRawDecoder;

    public RSErasureDecoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        ECBlock[] outputBlocks = this.getOutputBlocks(blockGroup);
        RawErasureDecoder rawDecoder = this.checkCreateRSRawDecoder();
        return new ErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), outputBlocks, rawDecoder);
    }

    private RawErasureDecoder checkCreateRSRawDecoder() {
        if (this.rsRawDecoder == null) {
            this.rsRawDecoder = CodecUtil.createRawDecoder(this.getConf(), "rs", this.getOptions());
        }
        return this.rsRawDecoder;
    }

    @Override
    public void release() {
        if (this.rsRawDecoder != null) {
            this.rsRawDecoder.release();
        }
    }
}

