/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicInteger;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;
import oadd.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import oadd.org.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterInt
extends MutableCounter {
    private AtomicInteger value = new AtomicInteger();

    MutableCounterInt(MetricsInfo info, int initValue) {
        super(info);
        this.value.set(initValue);
    }

    @Override
    public void incr() {
        this.incr(1);
    }

    public synchronized void incr(int delta) {
        this.value.addAndGet(delta);
        this.setChanged();
    }

    public int value() {
        return this.value.get();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value());
            this.clearChanged();
        }
    }
}

