/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import oadd.org.apache.commons.configuration2.SubsetConfiguration;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.AbstractMetric;
import oadd.org.apache.hadoop.metrics2.MetricsException;
import oadd.org.apache.hadoop.metrics2.MetricsRecord;
import oadd.org.apache.hadoop.metrics2.MetricsSink;
import oadd.org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileSink
implements MetricsSink,
Closeable {
    private static final String FILENAME_KEY = "filename";
    private PrintStream writer;

    @Override
    public void init(SubsetConfiguration conf) {
        String filename = conf.getString(FILENAME_KEY);
        try {
            this.writer = filename == null ? System.out : new PrintStream(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]), true, "UTF-8");
        }
        catch (Exception e) {
            throw new MetricsException("Error creating " + filename, e);
        }
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        this.writer.print(record.timestamp());
        this.writer.print(" ");
        this.writer.print(record.context());
        this.writer.print(".");
        this.writer.print(record.name());
        String separator = ": ";
        for (MetricsTag tag : record.tags()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(tag.name());
            this.writer.print("=");
            this.writer.print(tag.value());
        }
        for (AbstractMetric metric : record.metrics()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(metric.name());
            this.writer.print("=");
            this.writer.print(metric.value());
        }
        this.writer.println();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

