/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.net;

import java.io.IOException;
import java.net.URI;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.net.DNSDomainNameResolver;
import oadd.org.apache.hadoop.net.DomainNameResolver;
import oadd.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DomainNameResolverFactory {
    private DomainNameResolverFactory() {
    }

    public static DomainNameResolver newInstance(Configuration conf, URI uri, String configKey) throws IOException {
        String host = uri.getHost();
        String confKeyWithHost = configKey + "." + host;
        return DomainNameResolverFactory.newInstance(conf, confKeyWithHost);
    }

    public static DomainNameResolver newInstance(Configuration conf, String configKey) {
        Class<DomainNameResolver> resolverClass = conf.getClass(configKey, DNSDomainNameResolver.class, DomainNameResolver.class);
        return ReflectionUtils.newInstance(resolverClass, conf);
    }
}

