/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import oadd.org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import oadd.org.apache.hadoop.security.authorize.AuthorizationException;
import oadd.org.apache.hadoop.security.authorize.ProxyUsers;
import oadd.org.apache.hadoop.util.HttpExceptionUtils;
import oadd.org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUserAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUserAuthenticationFilter.class);
    private static final String DO_AS = "doas";
    public static final String PROXYUSER_PREFIX = "proxyuser";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Configuration conf = this.getProxyuserConfiguration(filterConfig);
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf, PROXYUSER_PREFIX);
        super.init(filterConfig);
    }

    @Override
    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletRequest lowerCaseRequest = ProxyUserAuthenticationFilter.toLowerCase(request);
        String doAsUser = lowerCaseRequest.getParameter(DO_AS);
        if (doAsUser != null && !doAsUser.equals(request.getRemoteUser())) {
            UserGroupInformation requestUgi;
            LOG.debug("doAsUser = {}, RemoteUser = {} , RemoteAddress = {} ", doAsUser, request.getRemoteUser(), request.getRemoteAddr());
            UserGroupInformation userGroupInformation = requestUgi = request.getUserPrincipal() != null ? UserGroupInformation.createRemoteUser(request.getRemoteUser()) : null;
            if (requestUgi != null) {
                requestUgi = UserGroupInformation.createProxyUser(doAsUser, requestUgi);
                try {
                    ProxyUsers.authorize(requestUgi, request.getRemoteAddr());
                    final UserGroupInformation ugiF = requestUgi;
                    request = new HttpServletRequestWrapper((HttpServletRequest)request){

                        public String getRemoteUser() {
                            return ugiF.getShortUserName();
                        }

                        public Principal getUserPrincipal() {
                            return new Principal(){

                                @Override
                                public String getName() {
                                    return ugiF.getUserName();
                                }
                            };
                        }
                    };
                    LOG.debug("Proxy user Authentication successful");
                }
                catch (AuthorizationException ex) {
                    HttpExceptionUtils.createServletExceptionResponse(response, 403, ex);
                    LOG.warn("Proxy user Authentication exception", ex);
                    return;
                }
            }
        }
        super.doFilter(filterChain, (HttpServletRequest)request, response);
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
        Configuration conf = new Configuration(false);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("proxyuser.")) continue;
            String value = filterConfig.getInitParameter(name);
            conf.set(name, value);
        }
        return conf;
    }

    static boolean containsUpperCase(Iterable<String> strings) {
        for (String s2 : strings) {
            for (int i = 0; i < s2.length(); ++i) {
                if (!Character.isUpperCase(s2.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static HttpServletRequest toLowerCase(HttpServletRequest request) {
        Map original = request.getParameterMap();
        if (!ProxyUserAuthenticationFilter.containsUpperCase(original.keySet())) {
            return request;
        }
        final HashMap m3 = new HashMap();
        for (Map.Entry entry : original.entrySet()) {
            String key = StringUtils.toLowerCase((String)entry.getKey());
            ArrayList<String> strings = (ArrayList<String>)m3.get(key);
            if (strings == null) {
                strings = new ArrayList<String>();
                m3.put(key, strings);
            }
            for (String v : (String[])entry.getValue()) {
                strings.add(v);
            }
        }
        return new HttpServletRequestWrapper(request){
            private Map<String, String[]> parameters;
            {
                super(x0);
                this.parameters = null;
            }

            public Map<String, String[]> getParameterMap() {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, String[]>();
                    for (Map.Entry entry : m3.entrySet()) {
                        List a = (List)entry.getValue();
                        this.parameters.put((String)entry.getKey(), a.toArray(new String[a.size()]));
                    }
                }
                return this.parameters;
            }

            public String getParameter(String name) {
                List a = (List)m3.get(name);
                return a == null ? null : (String)a.get(0);
            }

            public String[] getParameterValues(String name) {
                return this.getParameterMap().get(name);
            }

            public Enumeration<String> getParameterNames() {
                final Iterator i = m3.keySet().iterator();
                return new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return i.hasNext();
                    }

                    @Override
                    public String nextElement() {
                        return (String)i.next();
                    }
                };
            }
        };
    }
}

