/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.security.authorize;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import oadd.org.apache.hadoop.conf.Configuration;

public class ProxyServers {
    public static final String CONF_HADOOP_PROXYSERVERS = "hadoop.proxyservers";
    private static volatile Collection<String> proxyServers;

    public static void refresh() {
        ProxyServers.refresh(new Configuration());
    }

    public static void refresh(Configuration conf) {
        HashSet<String> tempServers = new HashSet<String>();
        for (String host : conf.getTrimmedStrings(CONF_HADOOP_PROXYSERVERS)) {
            InetSocketAddress addr = new InetSocketAddress(host, 0);
            if (addr.isUnresolved()) continue;
            tempServers.add(addr.getAddress().getHostAddress());
        }
        proxyServers = tempServers;
    }

    public static boolean isProxyServer(String remoteAddr) {
        if (proxyServers == null) {
            ProxyServers.refresh();
        }
        return proxyServers.contains(remoteAddr);
    }
}

