/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.util.function.Supplier;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.util.OperationDuration;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DurationInfo
extends OperationDuration
implements AutoCloseable {
    private final Supplier<String> text = () -> String.format(format, args);
    private String textStr;
    private final Logger log;
    private final boolean logAtInfo;

    public DurationInfo(Logger log, String format, Object ... args) {
        this(log, true, format, args);
    }

    public DurationInfo(Logger log, boolean logAtInfo, String format, Object ... args) {
        this.log = log;
        this.logAtInfo = logAtInfo;
        if (logAtInfo) {
            log.info("Starting: {}", (Object)this.getFormattedText());
        } else if (log.isDebugEnabled()) {
            log.debug("Starting: {}", (Object)this.getFormattedText());
        }
    }

    private String getFormattedText() {
        return this.textStr == null ? (this.textStr = this.text.get()) : this.textStr;
    }

    @Override
    public String toString() {
        return this.getFormattedText() + ": duration " + super.toString();
    }

    @Override
    public void close() {
        this.finished();
        if (this.logAtInfo) {
            this.log.info("{}", (Object)this);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("{}", (Object)this);
        }
    }
}

