/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);

    public static void sleepAtLeastIgnoreInterrupts(long millis) {
        long start = Time.now();
        while (Time.now() - start < millis) {
            long timeToSleep = millis - (Time.now() - start);
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.warn("interrupted while sleeping", ie);
            }
        }
    }

    public static void joinUninterruptibly(Thread toJoin) {
        boolean interrupted = false;
        while (true) {
            try {
                toJoin.join();
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                LOG.warn("interrupted while sleeping", e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new IOException("Can not read resource file '" + resourceName + "' because class loader of the current thread is null");
        }
        return ThreadUtil.getResourceAsStream(cl, resourceName);
    }

    public static InputStream getResourceAsStream(ClassLoader cl, String resourceName) throws IOException {
        if (cl == null) {
            throw new IOException("Can not read resource file '" + resourceName + "' because given class loader is null");
        }
        InputStream is = cl.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IOException("Can not read resource file '" + resourceName + "'");
        }
        return is;
    }
}

