/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FSBuilder;
import oadd.org.apache.hadoop.util.functional.CallableRaisingIOE;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class FutureIO {
    private FutureIO() {
    }

    public static <T> T awaitFuture(Future<T> future) throws InterruptedIOException, IOException, RuntimeException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIO.raiseInnerCause(e);
        }
    }

    public static <T> T awaitFuture(Future<T> future, long timeout, TimeUnit unit) throws InterruptedIOException, IOException, RuntimeException, TimeoutException {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            return FutureIO.raiseInnerCause(e);
        }
    }

    public static <T> T raiseInnerCause(ExecutionException e) throws IOException {
        throw FutureIO.unwrapInnerException(e);
    }

    public static <T> T raiseInnerCause(CompletionException e) throws IOException {
        throw FutureIO.unwrapInnerException(e);
    }

    public static IOException unwrapInnerException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof UncheckedIOException) {
            return ((UncheckedIOException)cause).getCause();
        }
        if (cause instanceof CompletionException) {
            return FutureIO.unwrapInnerException(cause);
        }
        if (cause instanceof ExecutionException) {
            return FutureIO.unwrapInnerException(cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause != null) {
            return new IOException(cause);
        }
        return new IOException(e);
    }

    public static <T, U extends FSBuilder<T, U>> FSBuilder<T, U> propagateOptions(FSBuilder<T, U> builder, Configuration conf, String optionalPrefix, String mandatoryPrefix) {
        FutureIO.propagateOptions(builder, conf, optionalPrefix, false);
        FutureIO.propagateOptions(builder, conf, mandatoryPrefix, true);
        return builder;
    }

    public static void propagateOptions(FSBuilder<?, ?> builder, Configuration conf, String prefix, boolean mandatory) {
        String p = prefix.endsWith(".") ? prefix : prefix + ".";
        Map<String, String> propsWithPrefix = conf.getPropsWithPrefix(p);
        for (Map.Entry<String, String> entry : propsWithPrefix.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (mandatory) {
                builder.must(key, val);
                continue;
            }
            builder.opt(key, val);
        }
    }

    public static <T> CompletableFuture<T> eval(CallableRaisingIOE<T> callable) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        try {
            result.complete(callable.apply());
        }
        catch (IllegalArgumentException | UnsupportedOperationException tx) {
            throw tx;
        }
        catch (Throwable tx) {
            result.completeExceptionally(tx);
        }
        return result;
    }
}

