/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.store.parquet.DataPageHeaderInfoProvider;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnChunkIncReadStore
implements PageReadStore {
    private static final Logger logger = LoggerFactory.getLogger(ColumnChunkIncReadStore.class);
    private static ParquetMetadataConverter METADATA_CONVERTER = new ParquetMetadataConverter();
    private CompressionCodecFactory codecFactory;
    private BufferAllocator allocator;
    private FileSystem fs;
    private Path path;
    private long rowCount;
    private List<FSDataInputStream> streams = new ArrayList<FSDataInputStream>();
    private Map<ColumnDescriptor, ColumnChunkIncPageReader> columns = new HashMap<ColumnDescriptor, ColumnChunkIncPageReader>();

    public ColumnChunkIncReadStore(long rowCount, CompressionCodecFactory codecFactory, BufferAllocator allocator, FileSystem fs, Path path) {
        this.codecFactory = codecFactory;
        this.allocator = allocator;
        this.fs = fs;
        this.path = path;
        this.rowCount = rowCount;
    }

    public void addColumn(ColumnDescriptor descriptor, ColumnChunkMetaData metaData) throws IOException {
        FSDataInputStream in = this.fs.open(this.path);
        this.streams.add(in);
        in.seek(metaData.getStartingPos());
        ColumnChunkIncPageReader reader = new ColumnChunkIncPageReader(metaData, descriptor, in);
        this.columns.put(descriptor, reader);
    }

    public void close() {
        for (FSDataInputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.warn("Error closing stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        for (ColumnChunkIncPageReader reader : this.columns.values()) {
            reader.close();
        }
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        return this.columns.get(descriptor);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public String toString() {
        return "ColumnChunkIncReadStore[File=" + String.valueOf(this.path.toUri()) + "]";
    }

    public class ColumnChunkIncPageReader
    implements PageReader {
        ColumnChunkMetaData metaData;
        ColumnDescriptor columnDescriptor;
        long fileOffset;
        long size;
        private long valueReadSoFar = 0L;
        private DictionaryPage dictionaryPage;
        private FSDataInputStream in;
        private CompressionCodecFactory.BytesInputDecompressor decompressor;
        private ByteBuf lastPage;

        public ColumnChunkIncPageReader(ColumnChunkMetaData metaData, ColumnDescriptor columnDescriptor, FSDataInputStream in) throws IOException {
            this.metaData = metaData;
            this.columnDescriptor = columnDescriptor;
            this.size = metaData.getTotalSize();
            this.fileOffset = metaData.getStartingPos();
            this.in = in;
            this.decompressor = ColumnChunkIncReadStore.this.codecFactory.getDecompressor(metaData.getCodec());
        }

        public DictionaryPage readDictionaryPage() {
            if (this.dictionaryPage == null) {
                PageHeader pageHeader = new PageHeader();
                long pos = 0L;
                try {
                    pos = this.in.getPos();
                    pageHeader = Util.readPageHeader((InputStream)this.in);
                    if (pageHeader.getDictionary_page_header() == null) {
                        this.in.seek(pos);
                        return null;
                    }
                    BytesInput dictPageBytes = this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)pageHeader.compressed_page_size), pageHeader.getUncompressed_page_size());
                    this.dictionaryPage = new DictionaryPage(dictPageBytes, pageHeader.getDictionary_page_header().getNum_values(), METADATA_CONVERTER.getEncoding(pageHeader.dictionary_page_header.encoding));
                }
                catch (Exception e) {
                    throw new DrillRuntimeException("Error reading dictionary page.\nFile path: " + ColumnChunkIncReadStore.this.path.toUri().getPath() + "\nRow count: " + ColumnChunkIncReadStore.this.rowCount + "\nColumn Chunk Metadata: " + String.valueOf(this.metaData) + "\nPage Header: " + String.valueOf(pageHeader) + "\nFile offset: " + this.fileOffset + "\nSize: " + this.size + "\nValue read so far: " + this.valueReadSoFar + "\nPosition: " + pos, e);
                }
            }
            return this.dictionaryPage;
        }

        public long getTotalValueCount() {
            return this.metaData.getValueCount();
        }

        public DataPage readPage() {
            PageHeader pageHeader = new PageHeader();
            try {
                if (this.lastPage != null) {
                    this.lastPage.release();
                    this.lastPage = null;
                }
                block8: while (this.valueReadSoFar < this.metaData.getValueCount()) {
                    pageHeader = Util.readPageHeader((InputStream)this.in);
                    int compPageSize = pageHeader.getCompressed_page_size();
                    int pageSize = pageHeader.getUncompressed_page_size();
                    switch (pageHeader.type) {
                        case DICTIONARY_PAGE: {
                            if (this.dictionaryPage == null) {
                                BytesInput pageBytes = this.decompressor.decompress(BytesInput.from((InputStream)this.in, (int)compPageSize), pageSize);
                                this.dictionaryPage = new DictionaryPage(pageBytes, pageSize, METADATA_CONVERTER.getEncoding(pageHeader.dictionary_page_header.encoding));
                                continue block8;
                            }
                            this.in.skip(compPageSize);
                            continue block8;
                        }
                        case DATA_PAGE: {
                            DataPageHeaderInfoProvider pageHeaderInfo = DataPageHeaderInfoProvider.builder((PageHeader)pageHeader);
                            this.valueReadSoFar += (long)pageHeaderInfo.getNumValues();
                            DrillBuf buf = ColumnChunkIncReadStore.this.allocator.buffer(compPageSize);
                            this.lastPage = buf;
                            ByteBuffer pageBuf = ((ByteBuf)buf).nioBuffer(0, compPageSize);
                            HadoopStreams.wrap((FSDataInputStream)this.in).readFully(pageBuf);
                            pageBuf.flip();
                            BytesInput pageBytes = this.decompressor.decompress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{pageBuf}), pageSize);
                            Statistics stats = METADATA_CONVERTER.fromParquetStatistics(null, pageHeaderInfo.getStatistics(), this.columnDescriptor.getPrimitiveType());
                            return new DataPageV1(pageBytes, pageHeaderInfo.getNumValues(), pageSize, stats, METADATA_CONVERTER.getEncoding(pageHeaderInfo.getRepetitionLevelEncoding()), METADATA_CONVERTER.getEncoding(pageHeaderInfo.getDefinitionLevelEncoding()), METADATA_CONVERTER.getEncoding(pageHeaderInfo.getEncoding()));
                        }
                        case DATA_PAGE_V2: {
                            DataPageHeaderInfoProvider pageHeaderInfo = DataPageHeaderInfoProvider.builder((PageHeader)pageHeader);
                            int repLevelSize = pageHeader.data_page_header_v2.getRepetition_levels_byte_length();
                            int defLevelSize = pageHeader.data_page_header_v2.getDefinition_levels_byte_length();
                            this.valueReadSoFar += (long)pageHeaderInfo.getNumValues();
                            DrillBuf buf = ColumnChunkIncReadStore.this.allocator.buffer(compPageSize);
                            this.lastPage = buf;
                            ByteBuffer pageBuf = ((ByteBuf)buf).nioBuffer(0, compPageSize);
                            HadoopStreams.wrap((FSDataInputStream)this.in).readFully(pageBuf);
                            pageBuf.flip();
                            int pageBufOffset = 0;
                            ByteBuffer bb = pageBuf.position(pageBufOffset);
                            BytesInput repLevelBytes = BytesInput.from((ByteBuffer[])new ByteBuffer[]{bb.slice().limit(repLevelSize)});
                            bb = pageBuf.position(pageBufOffset += repLevelSize);
                            BytesInput defLevelBytes = BytesInput.from((ByteBuffer[])new ByteBuffer[]{bb.slice().limit(defLevelSize)});
                            bb = pageBuf.position(pageBufOffset += defLevelSize);
                            BytesInput colDataBytes = this.decompressor.decompress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{bb.slice()}), pageSize - repLevelSize - defLevelSize);
                            Statistics stats = METADATA_CONVERTER.fromParquetStatistics(null, pageHeaderInfo.getStatistics(), this.columnDescriptor.getPrimitiveType());
                            return new DataPageV2(pageHeader.data_page_header_v2.getNum_rows(), pageHeader.data_page_header_v2.getNum_nulls(), pageHeaderInfo.getNumValues(), repLevelBytes, defLevelBytes, METADATA_CONVERTER.getEncoding(pageHeaderInfo.getEncoding()), colDataBytes, pageSize, stats, pageHeader.data_page_header_v2.isIs_compressed());
                        }
                    }
                    logger.warn("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compPageSize);
                    this.in.skip(compPageSize);
                }
                this.in.close();
                return null;
            }
            catch (OutOfMemoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DrillRuntimeException("Error reading page.\nFile path: " + ColumnChunkIncReadStore.this.path.toUri().getPath() + "\nRow count: " + ColumnChunkIncReadStore.this.rowCount + "\nColumn Chunk Metadata: " + String.valueOf(this.metaData) + "\nPage Header: " + String.valueOf(pageHeader) + "\nFile offset: " + this.fileOffset + "\nSize: " + this.size + "\nValue read so far: " + this.valueReadSoFar, e);
            }
        }

        void close() {
            this.decompressor.release();
            if (this.lastPage != null) {
                this.lastPage.release();
                this.lastPage = null;
            }
        }
    }
}

