/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.cassandra;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.adapter.cassandra.CalciteUtils;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.cassandra.CassandraStorageConfig;
import org.apache.drill.exec.store.cassandra.schema.CassandraRootDrillSchemaFactory;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(CassandraStoragePlugin.class);
    private final CassandraStorageConfig config;
    private final SchemaFactory schemaFactory;

    public CassandraStoragePlugin(CassandraStorageConfig config, DrillbitContext context, String name) {
        super(context, name);
        this.config = config;
        this.schemaFactory = new CassandraRootDrillSchemaFactory(name, this);
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        Optional<UsernamePasswordCredentials> userCreds;
        if (this.config.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION && !(userCreds = this.config.getUsernamePasswordCredentials(schemaConfig.getUserName())).isPresent()) {
            logger.debug("No schemas will be registered in {} for query user {}.", (Object)this.getName(), (Object)schemaConfig.getUserName());
            return;
        }
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public CassandraStorageConfig getConfig() {
        return this.config;
    }

    public boolean supportsRead() {
        return true;
    }

    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: 
            case LOGICAL: {
                return CalciteUtils.cassandraRules();
            }
        }
        return ImmutableSet.of();
    }
}

