/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class MembersSetPermissions2Arg {
    protected final UserSelectorArg user;
    protected final List<String> newRoles;

    public MembersSetPermissions2Arg(UserSelectorArg user, List<String> newRoles) {
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
        if (newRoles != null) {
            if (newRoles.size() > 1) {
                throw new IllegalArgumentException("List 'newRoles' has more than 1 items");
            }
            for (String x : newRoles) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'newRoles' is null");
                }
                if (x.length() > 128) {
                    throw new IllegalArgumentException("Stringan item in list 'newRoles' is longer than 128");
                }
                if (Pattern.matches("pid_dbtmr:.*", x)) continue;
                throw new IllegalArgumentException("Stringan item in list 'newRoles' does not match pattern");
            }
        }
        this.newRoles = newRoles;
    }

    public MembersSetPermissions2Arg(UserSelectorArg user) {
        this(user, null);
    }

    public UserSelectorArg getUser() {
        return this.user;
    }

    public List<String> getNewRoles() {
        return this.newRoles;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user, this.newRoles});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersSetPermissions2Arg other = (MembersSetPermissions2Arg)obj;
            return (this.user == other.user || this.user.equals(other.user)) && (this.newRoles == other.newRoles || this.newRoles != null && this.newRoles.equals(other.newRoles));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MembersSetPermissions2Arg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersSetPermissions2Arg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("user");
            UserSelectorArg.Serializer.INSTANCE.serialize(value.user, g);
            if (value.newRoles != null) {
                g.writeFieldName("new_roles");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.newRoles, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MembersSetPermissions2Arg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_newRoles;
            UserSelectorArg f_user;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_user = null;
                f_newRoles = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("user".equals(field)) {
                        f_user = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("new_roles".equals(field)) {
                        f_newRoles = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_user == null) {
                    throw new JsonParseException(p, "Required field \"user\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembersSetPermissions2Arg value = new MembersSetPermissions2Arg(f_user, f_newRoles);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

