/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@BoxResourceType(value="event")
public class BoxEvent
extends BoxResource {
    private BoxResource.Info sourceInfo;
    private Type type;
    private EventType eventType;
    private String typeName;
    private JsonObject sourceJSON;
    private Date createdAt;
    private String ipAddress;
    private JsonObject additionalDetails;
    private BoxCollaborator.Info accessibleBy;
    private BoxUser.Info createdBy;
    private String sessionID;
    private BoxUser.Info actionBy;

    public BoxEvent(BoxAPIConnection api, String json) {
        this(api, Json.parse((String)json).asObject());
    }

    BoxEvent(BoxAPIConnection api, JsonObject jsonObject) {
        super(api, jsonObject.get("event_id").asString());
        for (JsonObject.Member member : jsonObject) {
            if (member.getValue().isNull()) continue;
            this.parseJsonMember(member);
        }
    }

    public BoxResource.Info getSourceInfo() {
        return this.sourceInfo;
    }

    public JsonObject getSourceJSON() {
        return this.sourceJSON;
    }

    @Deprecated
    public Type getType() {
        return this.type;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public JsonObject getAdditionalDetails() {
        return this.additionalDetails;
    }

    public BoxCollaborator.Info getAccessibleBy() {
        return this.accessibleBy;
    }

    public BoxUser.Info getCreatedBy() {
        return this.createdBy;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public BoxUser.Info getActionBy() {
        return this.actionBy;
    }

    void parseJsonMember(JsonObject.Member member) {
        JsonValue value = member.getValue();
        if (value.isNull()) {
            return;
        }
        String memberName = member.getName();
        if (memberName.equals("source")) {
            try {
                this.sourceInfo = BoxResource.parseInfo(this.getAPI(), value.asObject());
            }
            catch (Exception e) {
                this.sourceInfo = null;
            }
            this.sourceJSON = JsonObject.unmodifiableObject((JsonObject)value.asObject());
        } else if (memberName.equals("event_type")) {
            String stringValue;
            this.typeName = stringValue = value.asString();
            for (Type t : Type.values()) {
                if (!t.name().equals(stringValue)) continue;
                this.type = t;
                break;
            }
            this.eventType = EventType.lookupByValue(stringValue);
            if (this.type == null || this.eventType == null) {
                this.type = Type.UNKNOWN;
                this.eventType = EventType.UNKNOWN;
            }
        } else if (memberName.equals("created_at")) {
            try {
                this.createdAt = BoxDateFormat.parse(value.asString());
            }
            catch (ParseException e) {
                assert (false) : "A ParseException indicates a bug in the SDK.";
            }
        } else if (memberName.equals("ip_address")) {
            this.ipAddress = value.asString();
        } else if (memberName.equals("additional_details")) {
            this.additionalDetails = value.asObject();
        } else if (memberName.equals("accessible_by")) {
            this.accessibleBy = (BoxCollaborator.Info)BoxResource.parseInfo(this.getAPI(), value.asObject());
        } else if (memberName.equals("created_by")) {
            this.createdBy = (BoxUser.Info)BoxResource.parseInfo(this.getAPI(), value.asObject());
        } else if (memberName.equals("session_id")) {
            this.sessionID = value.asString();
        } else if (memberName.equals("action_by")) {
            this.actionBy = (BoxUser.Info)BoxResource.parseInfo(this.getAPI(), value.asObject());
        }
    }

    public static enum EventType {
        UNKNOWN("UNKNOWN"),
        ITEM_CREATE("ITEM_CREATE"),
        ITEM_UPLOAD("ITEM_UPLOAD"),
        COMMENT_CREATE("COMMENT_CREATE"),
        COMMENT_DELETE("COMMENT_DELETE"),
        ITEM_DOWNLOAD("ITEM_DOWNLOAD"),
        ITEM_PREVIEW("ITEM_PREVIEW"),
        ITEM_MOVE("ITEM_MOVE"),
        ITEM_COPY("ITEM_COPY"),
        TASK_ASSIGNMENT_CREATE("TASK_ASSIGNMENT_CREATE"),
        TASK_ASSIGNMENT_COMPLETE("TASK_ASSIGNMENT_COMPLETE"),
        TASK_ASSIGNMENT_UPDATE("TASK_ASSIGNMENT_UPDATE"),
        TASK_CREATE("TASK_CREATE"),
        LOCK_CREATE("LOCK_CREATE"),
        LOCK_DESTROY("LOCK_DESTROY"),
        ITEM_TRASH("ITEM_TRASH"),
        ITEM_UNDELETE_VIA_TRASH("ITEM_UNDELETE_VIA_TRASH"),
        COLLAB_ADD_COLLABORATOR("COLLAB_ADD_COLLABORATOR"),
        COLLAB_ROLE_CHANGE("COLLAB_ROLE_CHANGE"),
        COLLAB_INVITE_COLLABORATOR("COLLAB_INVITE_COLLABORATOR"),
        COLLAB_REMOVE_COLLABORATOR("COLLAB_REMOVE_COLLABORATOR"),
        ITEM_SYNC("ITEM_SYNC"),
        ITEM_UNSYNC("ITEM_UNSYNC"),
        ITEM_RENAME("ITEM_RENAME"),
        ITEM_SHARED_CREATE("ITEM_SHARED_CREATE"),
        ITEM_SHARED_UNSHARE("ITEM_SHARED_UNSHARE"),
        ITEM_SHARED("ITEM_SHARED"),
        ITEM_MAKE_CURRENT_VERSION("ITEM_MAKE_CURRENT_VERSION"),
        TAG_ITEM_CREATE("TAG_ITEM_CREATE"),
        ENABLE_TWO_FACTOR_AUTH("ENABLE_TWO_FACTOR_AUTH"),
        ADMIN_INVITE_ACCEPT("MASTER_INVITE_ACCEPT"),
        ADMIN_INVITE_REJECT("MASTER_INVITE_REJECT"),
        ACCESS_GRANTED("ACCESS_GRANTED"),
        ACCESS_REVOKED("ACCESS_REVOKED"),
        ADD_LOGIN_ACTIVITY_DEVICE("ADD_LOGIN_ACTIVITY_DEVICE"),
        REMOVE_LOGIN_ACTIVITY_DEVICE("REMOVE_LOGIN_ACTIVITY_DEVICE"),
        CHANGE_ADMIN_ROLE("CHANGE_ADMIN_ROLE"),
        GROUP_ADD_USER("GROUP_ADD_USER"),
        NEW_USER("NEW_USER"),
        GROUP_CREATION("GROUP_CREATION"),
        GROUP_DELETION("GROUP_DELETION"),
        DELETE_USER("DELETE_USER"),
        GROUP_EDITED("GROUP_EDITED"),
        EDIT_USER("EDIT_USER"),
        GROUP_ADD_FOLDER("GROUP_ADD_FOLDER"),
        GROUP_ADD_FILE("GROUP_ADD_FILE"),
        GROUP_REMOVE_USER("GROUP_REMOVE_USER"),
        GROUP_REMOVE_FOLDER("GROUP_REMOVE_FOLDER"),
        GROUP_REMOVE_FILE("GROUP_REMOVE_FILE"),
        ADMIN_LOGIN("ADMIN_LOGIN"),
        ADD_DEVICE_ASSOCIATION("ADD_DEVICE_ASSOCIATION"),
        FAILED_LOGIN("FAILED_LOGIN"),
        LOGIN("LOGIN"),
        USER_AUTHENTICATE_OAUTH2_TOKEN_REFRESH("USER_AUTHENTICATE_OAUTH2_TOKEN_REFRESH"),
        REMOVE_DEVICE_ASSOCIATION("REMOVE_DEVICE_ASSOCIATION"),
        TERMS_OF_SERVICE_AGREE("TERMS_OF_SERVICE_AGREE"),
        TERMS_OF_SERVICE_REJECT("TERMS_OF_SERVICE_REJECT"),
        FILE_MARKED_MALICIOUS("FILE_MARKED_MALICIOUS"),
        COPY("COPY"),
        DELETE("DELETE"),
        DOWNLOAD("DOWNLOAD"),
        EDIT("EDIT"),
        LOCK("LOCK"),
        MOVE("MOVE"),
        PREVIEW("PREVIEW"),
        RENAME("RENAME"),
        STORAGE_EXPIRATION("STORAGE_EXPIRATION"),
        UNDELETE("UNDELETE"),
        UNLOCK("UNLOCK"),
        UPLOAD("UPLOAD"),
        SHARE("SHARE"),
        ITEM_SHARED_UPDATE("ITEM_SHARED_UPDATE"),
        UPDATE_SHARE_EXPIRATION("UPDATE_SHARE_EXPIRATION"),
        SHARE_EXPIRATION("SHARE_EXPIRATION"),
        UNSHARE("UNSHARE"),
        COLLABORATION_ACCEPT("COLLABORATION_ACCEPT"),
        COLLABORATION_ROLE_CHANGE("COLLABORATION_ROLE_CHANGE"),
        UPDATE_COLLABORATION_EXPIRATION("UPDATE_COLLABORATION_EXPIRATION"),
        COLLABORATION_REMOVE("COLLABORATION_REMOVE"),
        COLLABORATION_INVITE("COLLABORATION_INVITE"),
        COLLABORATION_EXPIRATION("COLLABORATION_EXPIRATION"),
        METADATA_INSTANCE_CREATE("METADATA_INSTANCE_CREATE"),
        METADATA_INSTANCE_UPDATE("METADATA_INSTANCE_UPDATE"),
        METADATA_INSTANCE_DELETE("METADATA_INSTANCE_DELETE"),
        CONTENT_WORKFLOW_UPLOAD_POLICY_VIOLATION("CONTENT_WORKFLOW_UPLOAD_POLICY_VIOLATION"),
        CHANGE_FOLDER_PERMISSION("CHANGE_FOLDER_PERMISSION"),
        TASK_ASSIGNMENT_DELETE("TASK_ASSIGNMENT_DELETE"),
        DATA_RETENTION_REMOVE_RETENTION("DATA_RETENTION_REMOVE_RETENTION"),
        DATA_RETENTION_CREATE_RETENTION("DATA_RETENTION_CREATE_RETENTION"),
        RETENTION_POLICY_ASSIGNMENT_ADD("RETENTION_POLICY_ASSIGNMENT_ADD"),
        LEGAL_HOLD_ASSIGNMENT_CREATE("LEGAL_HOLD_ASSIGNMENT_CREATE"),
        LEGAL_HOLD_ASSIGNMENT_DELETE("LEGAL_HOLD_ASSIGNMENT_DELETE"),
        LEGAL_HOLD_POLICY_DELETE("LEGAL_HOLD_POLICY_DELETE"),
        CONTENT_WORKFLOW_SHARING_POLICY_VIOLATION("CONTENT_WORKFLOW_SHARING_POLICY_VIOLATION"),
        APPLICATION_PUBLIC_KEY_ADDED("APPLICATION_PUBLIC_KEY_ADDED"),
        APPLICATION_PUBLIC_KEY_DELETED("APPLICATION_PUBLIC_KEY_DELETED"),
        CONTENT_WORKFLOW_POLICY_ADD("CONTENT_WORKFLOW_POLICY_ADD"),
        CONTENT_WORKFLOW_AUTOMATION_ADD("CONTENT_WORKFLOW_AUTOMATION_ADD"),
        CONTENT_WORKFLOW_AUTOMATION_DELETE("CONTENT_WORKFLOW_AUTOMATION_DELETE"),
        EMAIL_ALIAS_CONFIRM("EMAIL_ALIAS_CONFIRM"),
        EMAIL_ALIAS_REMOVE("EMAIL_ALIAS_REMOVE"),
        WATERMARK_LABEL_CREATE("WATERMARK_LABEL_CREATE"),
        WATERMARK_LABEL_DELETE("WATERMARK_LABEL_DELETE"),
        METADATA_TEMPLATE_CREATE("METADATA_TEMPLATE_CREATE"),
        METADATA_TEMPLATE_UPDATE("METADATA_TEMPLATE_UPDATE"),
        METADATA_TEMPLATE_DELETE("METADATA_TEMPLATE_DELETE"),
        ITEM_OPEN("ITEM_OPEN"),
        ITEM_MODIFY("ITEM_MODIFY"),
        CONTENT_WORKFLOW_ABNORMAL_DOWNLOAD_ACTIVITY("CONTENT_WORKFLOW_ABNORMAL_DOWNLOAD_ACTIVITY"),
        GROUP_REMOVE_ITEM("GROUP_REMOVE_ITEM"),
        GROUP_ADD_ITEM("GROUP_ADD_ITEM"),
        USER_AUTHENTICATE_OAUTH2_ACCESS_TOKEN_CREATE("USER_AUTHENTICATE_OAUTH2_ACCESS_TOKEN_CREATE"),
        CONTENT_ACCESS("CONTENT_ACCESS"),
        SHIELD_JUSTIFICATION_APPROVAL("SHIELD_JUSTIFICATION_APPROVAL"),
        TASK_UPDATE("TASK_UPDATE"),
        FILE_VERSION_RESTORE("FILE_VERSION_RESTORE"),
        ADVANCED_FOLDER_SETTINGS_UPDATE("ADVANCED_FOLDER_SETTINGS_UPDATE"),
        APPLICATION_CREATED("APPLICATION_CREATED"),
        DEVICE_TRUST_CHECK_FAILED("DEVICE_TRUST_CHECK_FAILED"),
        ENTERPRISE_APP_AUTHORIZATION_UPDATE("ENTERPRISE_APP_AUTHORIZATION_UPDATE"),
        FILE_WATERMARKED_DOWNLOAD("FILE_WATERMARKED_DOWNLOAD"),
        LEGAL_HOLD_POLICY_CREATE("LEGAL_HOLD_POLICY_CREATE"),
        LEGAL_HOLD_POLICY_UPDATE("LEGAL_HOLD_POLICY_UPDATE"),
        SHIELD_ALERT("SHIELD_ALERT"),
        SHIELD_EXTERNAL_COLLAB_ACCESS_BLOCKED("SHIELD_EXTERNAL_COLLAB_ACCESS_BLOCKED"),
        SHIELD_EXTERNAL_COLLAB_ACCESS_BLOCKED_MISSING_JUSTIFICATION("SHIELD_EXTERNAL_COLLAB_ACCESS_BLOCKED_MISSING_JUSTIFICATION"),
        SHIELD_EXTERNAL_COLLAB_INVITE_BLOCKED("SHIELD_EXTERNAL_COLLAB_INVITE_BLOCKED"),
        SHIELD_EXTERNAL_COLLAB_INVITE_BLOCKED_MISSING_JUSTIFICATION("SHIELD_EXTERNAL_COLLAB_INVITE_BLOCKED_MISSING_JUSTIFICATION"),
        SIGN_DOCUMENT_ASSIGNED("SIGN_DOCUMENT_ASSIGNED"),
        SIGN_DOCUMENT_CANCELLED("SIGN_DOCUMENT_CANCELLED"),
        SIGN_DOCUMENT_COMPLETED("SIGN_DOCUMENT_COMPLETED"),
        SIGN_DOCUMENT_CONVERTED("SIGN_DOCUMENT_CONVERTED"),
        SIGN_DOCUMENT_CREATED("SIGN_DOCUMENT_CREATED"),
        SIGN_DOCUMENT_DECLINED("SIGN_DOCUMENT_DECLINED"),
        SIGN_DOCUMENT_EXPIRED("SIGN_DOCUMENT_EXPIRED"),
        SIGN_DOCUMENT_SIGNED("SIGN_DOCUMENT_SIGNED"),
        SIGN_DOCUMENT_VIEWED_BY_SIGNER("SIGN_DOCUMENT_VIEWED_BY_SIGNER"),
        SIGNER_DOWNLOADED("SIGNER_DOWNLOADED"),
        SIGNER_FORWARDED("SIGNER_FORWARDED"),
        TERMS_OF_SERVICE_ACCEPT("TERMS_OF_SERVICE_ACCEPT");

        private static final Map<String, EventType> EVENT_TYPE_MAP;
        private final String jsonValue;

        private EventType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static EventType lookupByValue(String jsonValue) {
            return EVENT_TYPE_MAP.get(jsonValue);
        }

        String toJSONString() {
            return this.jsonValue;
        }

        static {
            EVENT_TYPE_MAP = new HashMap<String, EventType>(EventType.values().length);
            for (EventType event : EventType.values()) {
                EVENT_TYPE_MAP.put(event.jsonValue, event);
            }
        }
    }

    @Deprecated
    public static enum Type {
        UNKNOWN,
        ITEM_CREATE,
        ITEM_UPLOAD,
        COMMENT_CREATE,
        COMMENT_DELETE,
        ITEM_DOWNLOAD,
        ITEM_PREVIEW,
        ITEM_MOVE,
        ITEM_COPY,
        TASK_ASSIGNMENT_CREATE,
        TASK_ASSIGNMENT_COMPLETE,
        TASK_ASSIGNMENT_UPDATE,
        TASK_CREATE,
        LOCK_CREATE,
        LOCK_DESTROY,
        ITEM_TRASH,
        ITEM_UNDELETE_VIA_TRASH,
        COLLAB_ADD_COLLABORATOR,
        COLLAB_ROLE_CHANGE,
        COLLAB_INVITE_COLLABORATOR,
        COLLAB_REMOVE_COLLABORATOR,
        ITEM_SYNC,
        ITEM_UNSYNC,
        ITEM_RENAME,
        ITEM_SHARED_CREATE,
        ITEM_SHARED_UNSHARE,
        ITEM_SHARED,
        ITEM_MAKE_CURRENT_VERSION,
        TAG_ITEM_CREATE,
        ENABLE_TWO_FACTOR_AUTH,
        MASTER_INVITE_ACCEPT,
        MASTER_INVITE_REJECT,
        ACCESS_GRANTED,
        ACCESS_REVOKED,
        ADD_LOGIN_ACTIVITY_DEVICE,
        REMOVE_LOGIN_ACTIVITY_DEVICE,
        CHANGE_ADMIN_ROLE,
        GROUP_ADD_USER,
        NEW_USER,
        GROUP_CREATION,
        GROUP_DELETION,
        DELETE_USER,
        GROUP_EDITED,
        EDIT_USER,
        GROUP_ADD_FOLDER,
        GROUP_ADD_FILE,
        GROUP_REMOVE_USER,
        GROUP_REMOVE_FOLDER,
        GROUP_REMOVE_FILE,
        ADMIN_LOGIN,
        ADD_DEVICE_ASSOCIATION,
        FAILED_LOGIN,
        LOGIN,
        USER_AUTHENTICATE_OAUTH2_TOKEN_REFRESH,
        REMOVE_DEVICE_ASSOCIATION,
        TERMS_OF_SERVICE_AGREE,
        TERMS_OF_SERVICE_REJECT,
        FILE_MARKED_MALICIOUS,
        COPY,
        DELETE,
        DOWNLOAD,
        EDIT,
        LOCK,
        MOVE,
        PREVIEW,
        RENAME,
        STORAGE_EXPIRATION,
        UNDELETE,
        UNLOCK,
        UPLOAD,
        SHARE,
        ITEM_SHARED_UPDATE,
        UPDATE_SHARE_EXPIRATION,
        SHARE_EXPIRATION,
        UNSHARE,
        COLLABORATION_ACCEPT,
        COLLABORATION_ROLE_CHANGE,
        UPDATE_COLLABORATION_EXPIRATION,
        COLLABORATION_REMOVE,
        COLLABORATION_INVITE,
        COLLABORATION_EXPIRATION,
        METADATA_INSTANCE_CREATE,
        METADATA_INSTANCE_UPDATE,
        METADATA_INSTANCE_DELETE,
        CONTENT_WORKFLOW_UPLOAD_POLICY_VIOLATION,
        CHANGE_FOLDER_PERMISSION,
        TASK_ASSIGNMENT_DELETE,
        DATA_RETENTION_REMOVE_RETENTION,
        DATA_RETENTION_CREATE_RETENTION,
        RETENTION_POLICY_ASSIGNMENT_ADD,
        LEGAL_HOLD_ASSIGNMENT_CREATE,
        LEGAL_HOLD_ASSIGNMENT_DELETE,
        LEGAL_HOLD_POLICY_DELETE,
        CONTENT_WORKFLOW_SHARING_POLICY_VIOLATION,
        APPLICATION_PUBLIC_KEY_ADDED,
        APPLICATION_PUBLIC_KEY_DELETED,
        CONTENT_WORKFLOW_POLICY_ADD,
        CONTENT_WORKFLOW_AUTOMATION_ADD,
        CONTENT_WORKFLOW_AUTOMATION_DELETE,
        EMAIL_ALIAS_CONFIRM,
        EMAIL_ALIAS_REMOVE,
        WATERMARK_LABEL_CREATE,
        WATERMARK_LABEL_DELETE,
        METADATA_TEMPLATE_CREATE,
        METADATA_TEMPLATE_UPDATE,
        METADATA_TEMPLATE_DELETE,
        ITEM_OPEN,
        ITEM_MODIFY,
        CONTENT_WORKFLOW_ABNORMAL_DOWNLOAD_ACTIVITY,
        GROUP_REMOVE_ITEM,
        GROUP_ADD_ITEM,
        USER_AUTHENTICATE_OAUTH2_ACCESS_TOKEN_CREATE,
        CONTENT_ACCESS,
        SHIELD_JUSTIFICATION_APPROVAL,
        TASK_UPDATE,
        FILE_VERSION_RESTORE,
        ADVANCED_FOLDER_SETTINGS_UPDATE;

    }
}

