/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.expressions;

import java.util.StringJoiner;
import org.apache.drill.metastore.expressions.FilterExpression;

public abstract class DoubleExpressionPredicate
implements FilterExpression {
    private final FilterExpression right;
    private final FilterExpression.Operator operator;
    private final FilterExpression left;

    protected DoubleExpressionPredicate(FilterExpression right, FilterExpression.Operator operator, FilterExpression left) {
        this.right = right;
        this.operator = operator;
        this.left = left;
    }

    public FilterExpression right() {
        return this.right;
    }

    public FilterExpression left() {
        return this.left;
    }

    @Override
    public FilterExpression.Operator operator() {
        return this.operator;
    }

    public String toString() {
        return new StringJoiner(", ", DoubleExpressionPredicate.class.getSimpleName() + "[", "]").add("right=" + String.valueOf(this.right)).add("operator=" + String.valueOf((Object)this.operator)).add("left=" + String.valueOf(this.left)).toString();
    }

    public static class Or
    extends DoubleExpressionPredicate {
        public Or(FilterExpression right, FilterExpression left) {
            super(right, FilterExpression.Operator.OR, left);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class And
    extends DoubleExpressionPredicate {
        public And(FilterExpression right, FilterExpression left) {
            super(right, FilterExpression.Operator.AND, left);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }
}

