/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsKind;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class StatisticsHolder<T> {
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtils.createObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writerFor(StatisticsHolder.class);
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.readerFor(StatisticsHolder.class);
    private final T statisticsValue;
    private final BaseStatisticsKind<?> statisticsKind;

    @JsonCreator
    public StatisticsHolder(@JsonProperty(value="statisticsValue") T statisticsValue, @JsonProperty(value="statisticsKind") BaseStatisticsKind<?> statisticsKind) {
        this.statisticsValue = statisticsValue;
        this.statisticsKind = statisticsKind;
    }

    public StatisticsHolder(T statisticsValue, StatisticsKind<?> statisticsKind) {
        this.statisticsValue = statisticsValue;
        this.statisticsKind = (BaseStatisticsKind)statisticsKind;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    public T getStatisticsValue() {
        return this.statisticsValue;
    }

    public StatisticsKind<?> getStatisticsKind() {
        return this.statisticsKind;
    }

    public String jsonString() {
        try {
            return OBJECT_WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert statistics holder to json string", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsHolder that = (StatisticsHolder)o;
        return Objects.equals(this.statisticsValue, that.statisticsValue) && Objects.equals(this.statisticsKind, that.statisticsKind);
    }

    public int hashCode() {
        return Objects.hash(this.statisticsValue, this.statisticsKind);
    }

    public String toString() {
        return new StringJoiner(",\n", StatisticsHolder.class.getSimpleName() + "[\n", "]").add("statisticsValue=" + String.valueOf(this.statisticsValue)).add("statisticsKind=" + String.valueOf(this.statisticsKind)).toString();
    }

    public static StatisticsHolder<?> of(String serialized) {
        try {
            return (StatisticsHolder)OBJECT_READER.readValue(serialized);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert statistics holder from json string: " + serialized, e);
        }
    }
}

