/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerRegistry
implements ConnectionRegistry {
    private final HRegionServer regionServer;

    public RegionServerRegistry(HRegionServer regionServer) {
        this.regionServer = regionServer;
    }

    public CompletableFuture<RegionLocations> getMetaRegionLocations() {
        CompletableFuture<RegionLocations> future = new CompletableFuture<RegionLocations>();
        Optional<List<HRegionLocation>> locs = this.regionServer.getMetaRegionLocationCache().getMetaRegionLocations();
        if (locs.isPresent()) {
            List<HRegionLocation> list = locs.get();
            if (list.isEmpty()) {
                future.completeExceptionally(new IOException("no meta location available"));
            } else {
                future.complete(new RegionLocations(list));
            }
        } else {
            future.completeExceptionally(new IOException("no meta location available"));
        }
        return future;
    }

    public CompletableFuture<String> getClusterId() {
        return CompletableFuture.completedFuture(this.regionServer.getClusterId());
    }

    public CompletableFuture<ServerName> getActiveMaster() {
        CompletableFuture<ServerName> future = new CompletableFuture<ServerName>();
        Optional<ServerName> activeMaster = this.regionServer.getActiveMaster();
        if (activeMaster.isPresent()) {
            future.complete(activeMaster.get());
        } else {
            future.completeExceptionally(new IOException("no active master available"));
        }
        return future;
    }

    public String getConnectionString() {
        return "short-circuit";
    }

    public void close() {
    }
}

