/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.MoveRegionAction;
import org.apache.hadoop.hbase.master.balancer.SwapRegionsAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CandidateGenerator {
    CandidateGenerator() {
    }

    abstract BalanceAction generate(BalancerClusterState var1);

    int pickRandomRegion(BalancerClusterState cluster, int server, double chanceOfNoSwap) {
        if (cluster.regionsPerServer[server].length == 0 || (double)ThreadLocalRandom.current().nextFloat() < chanceOfNoSwap) {
            return -1;
        }
        int rand = ThreadLocalRandom.current().nextInt(cluster.regionsPerServer[server].length);
        return cluster.regionsPerServer[server][rand];
    }

    int pickRandomServer(BalancerClusterState cluster) {
        if (cluster.numServers < 1) {
            return -1;
        }
        return ThreadLocalRandom.current().nextInt(cluster.numServers);
    }

    int pickRandomRack(BalancerClusterState cluster) {
        if (cluster.numRacks < 1) {
            return -1;
        }
        return ThreadLocalRandom.current().nextInt(cluster.numRacks);
    }

    int pickOtherRandomServer(BalancerClusterState cluster, int serverIndex) {
        int otherServerIndex;
        if (cluster.numServers < 2) {
            return -1;
        }
        while ((otherServerIndex = this.pickRandomServer(cluster)) == serverIndex) {
        }
        return otherServerIndex;
    }

    int pickOtherRandomRack(BalancerClusterState cluster, int rackIndex) {
        int otherRackIndex;
        if (cluster.numRacks < 2) {
            return -1;
        }
        while ((otherRackIndex = this.pickRandomRack(cluster)) == rackIndex) {
        }
        return otherRackIndex;
    }

    BalanceAction pickRandomRegions(BalancerClusterState cluster, int thisServer, int otherServer) {
        int otherRegionCount;
        if (thisServer < 0 || otherServer < 0) {
            return BalanceAction.NULL_ACTION;
        }
        int thisRegionCount = cluster.getNumRegions(thisServer);
        double thisChance = thisRegionCount > (otherRegionCount = cluster.getNumRegions(otherServer)) ? 0.0 : 0.5;
        double otherChance = thisRegionCount <= otherRegionCount ? 0.0 : 0.5;
        int thisRegion = this.pickRandomRegion(cluster, thisServer, thisChance);
        int otherRegion = this.pickRandomRegion(cluster, otherServer, otherChance);
        return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
    }

    protected BalanceAction getAction(int fromServer, int fromRegion, int toServer, int toRegion) {
        if (fromServer < 0 || toServer < 0) {
            return BalanceAction.NULL_ACTION;
        }
        if (fromRegion >= 0 && toRegion >= 0) {
            return new SwapRegionsAction(fromServer, fromRegion, toServer, toRegion);
        }
        if (fromRegion >= 0) {
            return new MoveRegionAction(fromRegion, fromServer, toServer);
        }
        if (toRegion >= 0) {
            return new MoveRegionAction(toRegion, toServer, fromServer);
        }
        return BalanceAction.NULL_ACTION;
    }
}

