/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.circuitbreaker;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;

public class CircuitBreakerConfiguration {
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 80;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 30;
    public static final int DEFAULT_PERMITTED_CALLS_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 10;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 120;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60;
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    public static final int TOO_MANY_REQUESTS = Response.Status.TOO_MANY_REQUESTS.getStatusCode();
    public static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    public static final int SERVICE_UNAVAILABLE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    public static final int BAD_GATEWAY = Response.Status.BAD_GATEWAY.getStatusCode();
    public static final int GATEWAY_TIMEOUT = Response.Status.GATEWAY_TIMEOUT.getStatusCode();
    private final int failureRateThreshold;
    private final int slowCallRateThreshold;
    private final Duration waitDurationInOpenState;
    private final int permittedNumberOfCallsInHalfOpenState;
    private final int minimumNumberOfCalls;
    private final int slidingWindowSize;
    private final Duration slowCallDurationThreshold;
    private final boolean writableStackTraceEnabled;
    private final Set<Integer> recordHttpStatuses;
    public static final Class<ProcessingException> PROCESSING_EXCEPTION_CLASS = ProcessingException.class;
    public static final Class<ServiceUnavailableException> SERVICE_UNAVAILABLE_EXCEPTION_CLASS = ServiceUnavailableException.class;
    public static final Class<InternalServerErrorException> INTERNAL_SERVER_ERROR_EXCEPTION_CLASS = InternalServerErrorException.class;
    private final List<Class<? extends RuntimeException>> recordExceptions;

    private static int $default$failureRateThreshold() {
        return 80;
    }

    private static int $default$slowCallRateThreshold() {
        return 100;
    }

    private static Duration $default$waitDurationInOpenState() {
        return Duration.ofSeconds(30L);
    }

    private static int $default$permittedNumberOfCallsInHalfOpenState() {
        return 10;
    }

    private static int $default$minimumNumberOfCalls() {
        return 10;
    }

    private static int $default$slidingWindowSize() {
        return 120;
    }

    private static Duration $default$slowCallDurationThreshold() {
        return Duration.ofMinutes(60L);
    }

    private static boolean $default$writableStackTraceEnabled() {
        return true;
    }

    private static Set<Integer> $default$recordHttpStatuses() {
        return Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(TOO_MANY_REQUESTS, INTERNAL_SERVER_ERROR, BAD_GATEWAY, SERVICE_UNAVAILABLE, GATEWAY_TIMEOUT)));
    }

    private static List<Class<? extends RuntimeException>> $default$recordExceptions() {
        return Collections.unmodifiableList(Arrays.asList(PROCESSING_EXCEPTION_CLASS, SERVICE_UNAVAILABLE_EXCEPTION_CLASS, INTERNAL_SERVER_ERROR_EXCEPTION_CLASS));
    }

    @ConstructorProperties(value={"failureRateThreshold", "slowCallRateThreshold", "waitDurationInOpenState", "permittedNumberOfCallsInHalfOpenState", "minimumNumberOfCalls", "slidingWindowSize", "slowCallDurationThreshold", "writableStackTraceEnabled", "recordHttpStatuses", "recordExceptions"})
    CircuitBreakerConfiguration(int failureRateThreshold, int slowCallRateThreshold, Duration waitDurationInOpenState, int permittedNumberOfCallsInHalfOpenState, int minimumNumberOfCalls, int slidingWindowSize, Duration slowCallDurationThreshold, boolean writableStackTraceEnabled, Set<Integer> recordHttpStatuses, List<Class<? extends RuntimeException>> recordExceptions) {
        this.failureRateThreshold = failureRateThreshold;
        this.slowCallRateThreshold = slowCallRateThreshold;
        this.waitDurationInOpenState = waitDurationInOpenState;
        this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
        this.minimumNumberOfCalls = minimumNumberOfCalls;
        this.slidingWindowSize = slidingWindowSize;
        this.slowCallDurationThreshold = slowCallDurationThreshold;
        this.writableStackTraceEnabled = writableStackTraceEnabled;
        this.recordHttpStatuses = recordHttpStatuses;
        this.recordExceptions = recordExceptions;
    }

    public static CircuitBreakerConfigurationBuilder builder() {
        return new CircuitBreakerConfigurationBuilder();
    }

    public int getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public int getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public Duration getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public Duration getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public Set<Integer> getRecordHttpStatuses() {
        return this.recordHttpStatuses;
    }

    public List<Class<? extends RuntimeException>> getRecordExceptions() {
        return this.recordExceptions;
    }

    public static class CircuitBreakerConfigurationBuilder {
        private boolean failureRateThreshold$set;
        private int failureRateThreshold$value;
        private boolean slowCallRateThreshold$set;
        private int slowCallRateThreshold$value;
        private boolean waitDurationInOpenState$set;
        private Duration waitDurationInOpenState$value;
        private boolean permittedNumberOfCallsInHalfOpenState$set;
        private int permittedNumberOfCallsInHalfOpenState$value;
        private boolean minimumNumberOfCalls$set;
        private int minimumNumberOfCalls$value;
        private boolean slidingWindowSize$set;
        private int slidingWindowSize$value;
        private boolean slowCallDurationThreshold$set;
        private Duration slowCallDurationThreshold$value;
        private boolean writableStackTraceEnabled$set;
        private boolean writableStackTraceEnabled$value;
        private boolean recordHttpStatuses$set;
        private Set<Integer> recordHttpStatuses$value;
        private boolean recordExceptions$set;
        private List<Class<? extends RuntimeException>> recordExceptions$value;

        CircuitBreakerConfigurationBuilder() {
        }

        public CircuitBreakerConfigurationBuilder failureRateThreshold(int failureRateThreshold) {
            this.failureRateThreshold$value = failureRateThreshold;
            this.failureRateThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slowCallRateThreshold(int slowCallRateThreshold) {
            this.slowCallRateThreshold$value = slowCallRateThreshold;
            this.slowCallRateThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder waitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState$value = waitDurationInOpenState;
            this.waitDurationInOpenState$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder permittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            this.permittedNumberOfCallsInHalfOpenState$value = permittedNumberOfCallsInHalfOpenState;
            this.permittedNumberOfCallsInHalfOpenState$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder minimumNumberOfCalls(int minimumNumberOfCalls) {
            this.minimumNumberOfCalls$value = minimumNumberOfCalls;
            this.minimumNumberOfCalls$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slidingWindowSize(int slidingWindowSize) {
            this.slidingWindowSize$value = slidingWindowSize;
            this.slidingWindowSize$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder slowCallDurationThreshold(Duration slowCallDurationThreshold) {
            this.slowCallDurationThreshold$value = slowCallDurationThreshold;
            this.slowCallDurationThreshold$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled$value = writableStackTraceEnabled;
            this.writableStackTraceEnabled$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder recordHttpStatuses(Set<Integer> recordHttpStatuses) {
            this.recordHttpStatuses$value = recordHttpStatuses;
            this.recordHttpStatuses$set = true;
            return this;
        }

        public CircuitBreakerConfigurationBuilder recordExceptions(List<Class<? extends RuntimeException>> recordExceptions) {
            this.recordExceptions$value = recordExceptions;
            this.recordExceptions$set = true;
            return this;
        }

        public CircuitBreakerConfiguration build() {
            int failureRateThreshold$value = this.failureRateThreshold$value;
            if (!this.failureRateThreshold$set) {
                failureRateThreshold$value = CircuitBreakerConfiguration.$default$failureRateThreshold();
            }
            int slowCallRateThreshold$value = this.slowCallRateThreshold$value;
            if (!this.slowCallRateThreshold$set) {
                slowCallRateThreshold$value = CircuitBreakerConfiguration.$default$slowCallRateThreshold();
            }
            Duration waitDurationInOpenState$value = this.waitDurationInOpenState$value;
            if (!this.waitDurationInOpenState$set) {
                waitDurationInOpenState$value = CircuitBreakerConfiguration.$default$waitDurationInOpenState();
            }
            int permittedNumberOfCallsInHalfOpenState$value = this.permittedNumberOfCallsInHalfOpenState$value;
            if (!this.permittedNumberOfCallsInHalfOpenState$set) {
                permittedNumberOfCallsInHalfOpenState$value = CircuitBreakerConfiguration.$default$permittedNumberOfCallsInHalfOpenState();
            }
            int minimumNumberOfCalls$value = this.minimumNumberOfCalls$value;
            if (!this.minimumNumberOfCalls$set) {
                minimumNumberOfCalls$value = CircuitBreakerConfiguration.$default$minimumNumberOfCalls();
            }
            int slidingWindowSize$value = this.slidingWindowSize$value;
            if (!this.slidingWindowSize$set) {
                slidingWindowSize$value = CircuitBreakerConfiguration.$default$slidingWindowSize();
            }
            Duration slowCallDurationThreshold$value = this.slowCallDurationThreshold$value;
            if (!this.slowCallDurationThreshold$set) {
                slowCallDurationThreshold$value = CircuitBreakerConfiguration.$default$slowCallDurationThreshold();
            }
            boolean writableStackTraceEnabled$value = this.writableStackTraceEnabled$value;
            if (!this.writableStackTraceEnabled$set) {
                writableStackTraceEnabled$value = CircuitBreakerConfiguration.$default$writableStackTraceEnabled();
            }
            Set recordHttpStatuses$value = this.recordHttpStatuses$value;
            if (!this.recordHttpStatuses$set) {
                recordHttpStatuses$value = CircuitBreakerConfiguration.$default$recordHttpStatuses();
            }
            List recordExceptions$value = this.recordExceptions$value;
            if (!this.recordExceptions$set) {
                recordExceptions$value = CircuitBreakerConfiguration.$default$recordExceptions();
            }
            return new CircuitBreakerConfiguration(failureRateThreshold$value, slowCallRateThreshold$value, waitDurationInOpenState$value, permittedNumberOfCallsInHalfOpenState$value, minimumNumberOfCalls$value, slidingWindowSize$value, slowCallDurationThreshold$value, writableStackTraceEnabled$value, recordHttpStatuses$value, recordExceptions$value);
        }

        public String toString() {
            return "CircuitBreakerConfiguration.CircuitBreakerConfigurationBuilder(failureRateThreshold$value=" + this.failureRateThreshold$value + ", slowCallRateThreshold$value=" + this.slowCallRateThreshold$value + ", waitDurationInOpenState$value=" + this.waitDurationInOpenState$value + ", permittedNumberOfCallsInHalfOpenState$value=" + this.permittedNumberOfCallsInHalfOpenState$value + ", minimumNumberOfCalls$value=" + this.minimumNumberOfCalls$value + ", slidingWindowSize$value=" + this.slidingWindowSize$value + ", slowCallDurationThreshold$value=" + this.slowCallDurationThreshold$value + ", writableStackTraceEnabled$value=" + this.writableStackTraceEnabled$value + ", recordHttpStatuses$value=" + this.recordHttpStatuses$value + ", recordExceptions$value=" + this.recordExceptions$value + ")";
        }
    }
}

