/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Command {
    private String appName;
    private Options rules = new Options();
    public String[] args = new String[0];
    public HashMap<String, Object> opts = new HashMap();
    public Boolean help = false;
    public static final HashMap<String, Object> defaultValues = new HashMap();

    Command(String appName) {
        defaultValues.put("scheme", "https");
        defaultValues.put("host", "localhost");
        defaultValues.put("port", 8089);
        this.appName = appName;
    }

    public static Command create() {
        return Command.create(null);
    }

    public static Command create(String appName) {
        return new Command(appName);
    }

    public static void error(String message, Object ... args) {
        System.err.format("Error: %s\n", String.format(message, args));
        System.exit(2);
    }

    public Options getRules() {
        return this.rules;
    }

    public Command init() {
        this.rules.addOption("h", "help", false, "Display this help message");
        this.rules.addOption(null, "host", true, "Host name (default localhost)");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withType(Integer.class);
        this.rules.addOption(OptionBuilder.create());
        this.rules.addOption(null, "scheme", true, "Scheme (default https)");
        this.rules.addOption(null, "username", true, "Username to login with");
        this.rules.addOption(null, "password", true, "Password to login with");
        this.rules.addOption(null, "app", true, "App/namespace context");
        this.rules.addOption(null, "owner", true, "Owner/user context");
        this.rules.addOption(null, "version", true, "Version (irrelevant for Java)");
        return this;
    }

    public Command addRule(String name, String description) {
        this.rules.addOption(null, name, false, description);
        return this;
    }

    public Command addRule(String name, Class argType, String description) {
        OptionBuilder.withLongOpt((String)name);
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withType((Object)argType);
        OptionBuilder.withDescription((String)description);
        this.rules.addOption(OptionBuilder.create());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command load(String path) {
        ArrayList<String> argList = new ArrayList<String>();
        try (FileReader fileReader = new FileReader(path);){
            String line;
            BufferedReader reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                if (!line.startsWith("-")) {
                    line = "--" + line;
                }
                argList.add(line);
            }
        }
        catch (IOException e) {
            Command.error(e.getMessage(), new Object[0]);
            return this;
        }
        this.parse(argList.toArray(new String[argList.size()]));
        return this;
    }

    public Command parse(String[] argv) {
        PosixParser parser = new PosixParser();
        CommandLine cmdline = null;
        try {
            cmdline = parser.parse(this.rules, argv);
        }
        catch (ParseException e) {
            Command.error(e.getMessage(), new Object[0]);
        }
        for (Option option : cmdline.getOptions()) {
            String name = option.getLongOpt();
            Object value = option.getValue();
            if (!option.hasArg()) {
                value = true;
            } else {
                Class type = (Class)option.getType();
                if (type != null) {
                    if (type == Integer.class) {
                        value = Integer.parseInt((String)value);
                    } else assert (false);
                }
            }
            this.opts.put(name, value);
            try {
                Field field = this.getClass().getField(name);
                field.set(this, value);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        String[] orig = this.args;
        String[] more = cmdline.getArgs();
        this.args = new String[orig.length + more.length];
        System.arraycopy(orig, 0, this.args, 0, orig.length);
        System.arraycopy(more, 0, this.args, orig.length, more.length);
        if (this.help.booleanValue()) {
            this.printHelp();
            System.exit(0);
        }
        return this;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String appName = this.appName == null ? "App" : this.appName;
        formatter.printHelp(appName, this.rules);
    }

    public static Command splunk() {
        return Command.splunk(null);
    }

    public static Command splunk(String appName) {
        return Command.create(appName).init().splunkrc();
    }

    public Command splunkrc() {
        this.opts.putAll(defaultValues);
        this.load(System.getProperty("user.home") + File.separator + ".splunkrc");
        return this;
    }
}

