/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.List;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CassandraLimit
extends SingleRel
implements CassandraRel {
    public final @Nullable RexNode offset;
    public final @Nullable RexNode fetch;

    public CassandraLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, input);
        this.offset = offset;
        this.fetch = fetch;
        assert (this.getConvention() == input.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    public CassandraLimit copy(RelTraitSet traitSet, List<RelNode> newInputs) {
        return new CassandraLimit(this.getCluster(), traitSet, (RelNode)CassandraLimit.sole(newInputs), this.offset, this.fetch);
    }

    @Override
    public void implement(CassandraRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (this.offset != null) {
            implementor.offset = RexLiteral.intValue((RexNode)this.offset);
        }
        if (this.fetch != null) {
            implementor.fetch = RexLiteral.intValue((RexNode)this.fetch);
        }
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.itemIf("offset", (Object)this.offset, this.offset != null);
        pw.itemIf("fetch", (Object)this.fetch, this.fetch != null);
        return pw;
    }
}

