/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class BaseOverwriteFiles
extends MergingSnapshotProducer<OverwriteFiles>
implements OverwriteFiles {
    private final Set<DataFile> deletedDataFiles = Sets.newHashSet();
    private boolean validateAddedFilesMatchOverwriteFilter = false;
    private Long startingSnapshotId = null;
    private Expression conflictDetectionFilter = null;
    private boolean validateNewDataFiles = false;
    private boolean validateNewDeleteFiles = false;
    private boolean caseSensitive = true;

    protected BaseOverwriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        this.add(file);
        return this;
    }

    public OverwriteFiles deleteFile(DataFile file) {
        this.deletedDataFiles.add(file);
        this.delete(file);
        return this;
    }

    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.validateAddedFilesMatchOverwriteFilter = true;
        return this;
    }

    @Deprecated
    public OverwriteFiles validateNoConflictingAppends(Long newReadSnapshotId, Expression newConflictDetectionFilter) {
        if (newReadSnapshotId != null) {
            this.validateFromSnapshot(newReadSnapshotId);
        }
        this.validateNoConflictingAppends(newConflictDetectionFilter);
        return this;
    }

    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    public OverwriteFiles caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    public OverwriteFiles conflictDetectionFilter(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument((newConflictDetectionFilter != null ? 1 : 0) != 0, (Object)"Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    public OverwriteFiles validateNoConflictingData() {
        this.validateNewDataFiles = true;
        this.failMissingDeletePaths();
        return this;
    }

    public OverwriteFiles validateNoConflictingDeletes() {
        this.validateNewDeleteFiles = true;
        this.failMissingDeletePaths();
        return this;
    }

    @Override
    protected void validate(TableMetadata base) {
        if (this.validateAddedFilesMatchOverwriteFilter) {
            PartitionSpec spec = this.writeSpec();
            Expression rowFilter = this.rowFilter();
            Expression inclusiveExpr = Projections.inclusive((PartitionSpec)spec).project(rowFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            Expression strictExpr = Projections.strict((PartitionSpec)spec).project(rowFilter);
            Evaluator strict = new Evaluator(spec.partitionType(), strictExpr);
            StrictMetricsEvaluator metrics = new StrictMetricsEvaluator(base.schema(), rowFilter);
            for (DataFile file : this.addedFiles()) {
                ValidationException.check((inclusive.eval(file.partition()) && (strict.eval(file.partition()) || metrics.eval((ContentFile)file)) ? 1 : 0) != 0, (String)"Cannot append file with rows that do not match filter: %s: %s", (Object[])new Object[]{rowFilter, file.path()});
            }
        }
        if (this.validateNewDataFiles) {
            this.validateAddedDataFiles(base, this.startingSnapshotId, this.dataConflictDetectionFilter(), this.caseSensitive);
        }
        if (this.validateNewDeleteFiles) {
            if (this.rowFilter() != Expressions.alwaysFalse()) {
                Expression filter = this.conflictDetectionFilter != null ? this.conflictDetectionFilter : this.rowFilter();
                this.validateNoNewDeleteFiles(base, this.startingSnapshotId, filter, this.caseSensitive);
            }
            if (this.deletedDataFiles.size() > 0) {
                this.validateNoNewDeletesForDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, this.deletedDataFiles, this.caseSensitive);
            }
        }
    }

    private Expression dataConflictDetectionFilter() {
        if (this.conflictDetectionFilter != null) {
            return this.conflictDetectionFilter;
        }
        if (this.rowFilter() != Expressions.alwaysFalse() && this.deletedDataFiles.isEmpty()) {
            return this.rowFilter();
        }
        return Expressions.alwaysTrue();
    }
}

