/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.model.ArchivalState;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(HeadObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static HeadObjectRequest interceptRequest(HeadObjectRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, HeadObjectRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("o").path(HttpUtils.encodePathSegment((String)request.getObjectName()));
        if (request.getVersionId() != null) {
            target = target.queryParam("versionId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getVersionId())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", (Object)request.getIfNoneMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        if (request.getOpcSseCustomerAlgorithm() != null) {
            ib.header("opc-sse-customer-algorithm", (Object)request.getOpcSseCustomerAlgorithm());
        }
        if (request.getOpcSseCustomerKey() != null) {
            ib.header("opc-sse-customer-key", (Object)request.getOpcSseCustomerKey());
        }
        if (request.getOpcSseCustomerKeySha256() != null) {
            ib.header("opc-sse-customer-key-sha256", (Object)request.getOpcSseCustomerKeySha256());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, HeadObjectResponse> fromResponse() {
        Function<Response, HeadObjectResponse> transformer = new Function<Response, HeadObjectResponse>(){

            public HeadObjectResponse apply(Response rawResponse) {
                Optional versionIdHeader;
                Optional timeOfArchivalHeader;
                Optional archivalStateHeader;
                Optional storageTierHeader;
                Optional lastModifiedHeader;
                Optional contentDispositionHeader;
                Optional cacheControlHeader;
                Optional contentEncodingHeader;
                Optional contentLanguageHeader;
                Optional contentTypeHeader;
                Optional opcMultipartMd5Header;
                Optional contentMd5Header;
                Optional contentLengthHeader;
                Optional eTagHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.HeadObjectResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                HeadObjectResponse.Builder builder = HeadObjectResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                if (response.getStatusCode() != 304) {
                    builder.isNotModified(false);
                } else {
                    builder.isNotModified(true);
                }
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                HashMap<String, String> opcMeta = new HashMap<String, String>();
                String opcMetaPattern = "opc-meta-".toLowerCase(Locale.ROOT);
                for (Map.Entry header : headers.entrySet()) {
                    if (!((String)header.getKey()).toLowerCase(Locale.ROOT).startsWith(opcMetaPattern)) continue;
                    opcMeta.put((String)header.getKey(), (String)((List)header.getValue()).get(0));
                }
                if (opcMeta.size() > 0) {
                    builder.opcMeta(opcMeta);
                }
                if ((contentLengthHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((contentMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"content-md5")).isPresent()) {
                    builder.contentMd5((String)HeaderUtils.toValue((String)"content-md5", (String)((String)((List)contentMd5Header.get()).get(0)), String.class));
                }
                if ((opcMultipartMd5Header = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-multipart-md5")).isPresent()) {
                    builder.opcMultipartMd5((String)HeaderUtils.toValue((String)"opc-multipart-md5", (String)((String)((List)opcMultipartMd5Header.get()).get(0)), String.class));
                }
                if ((contentTypeHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-type")).isPresent()) {
                    builder.contentType((String)HeaderUtils.toValue((String)"content-type", (String)((String)((List)contentTypeHeader.get()).get(0)), String.class));
                }
                if ((contentLanguageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-language")).isPresent()) {
                    builder.contentLanguage((String)HeaderUtils.toValue((String)"content-language", (String)((String)((List)contentLanguageHeader.get()).get(0)), String.class));
                }
                if ((contentEncodingHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-encoding")).isPresent()) {
                    builder.contentEncoding((String)HeaderUtils.toValue((String)"content-encoding", (String)((String)((List)contentEncodingHeader.get()).get(0)), String.class));
                }
                if ((cacheControlHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"cache-control")).isPresent()) {
                    builder.cacheControl((String)HeaderUtils.toValue((String)"cache-control", (String)((String)((List)cacheControlHeader.get()).get(0)), String.class));
                }
                if ((contentDispositionHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-disposition")).isPresent()) {
                    builder.contentDisposition((String)HeaderUtils.toValue((String)"content-disposition", (String)((String)((List)contentDispositionHeader.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                if ((storageTierHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"storage-tier")).isPresent()) {
                    builder.storageTier((StorageTier)((Object)HeaderUtils.toValue((String)"storage-tier", (String)((String)((List)storageTierHeader.get()).get(0)), StorageTier.class)));
                }
                if ((archivalStateHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"archival-state")).isPresent()) {
                    builder.archivalState((ArchivalState)((Object)HeaderUtils.toValue((String)"archival-state", (String)((String)((List)archivalStateHeader.get()).get(0)), ArchivalState.class)));
                }
                if ((timeOfArchivalHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"time-of-archival")).isPresent()) {
                    builder.timeOfArchival((Date)HeaderUtils.toValue((String)"time-of-archival", (String)((String)((List)timeOfArchivalHeader.get()).get(0)), Date.class));
                }
                if ((versionIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"version-id")).isPresent()) {
                    builder.versionId((String)HeaderUtils.toValue((String)"version-id", (String)((String)((List)versionIdHeader.get()).get(0)), String.class));
                }
                HeadObjectResponse responseWrapper = builder.build();
                responseWrapper = ObjectMetadataInterceptor.intercept(responseWrapper);
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

