/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.narcissus;

import io.github.toolfactory.narcissus.LibraryLoader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Narcissus {
    public static final boolean libraryLoaded;
    private static final boolean DEBUG = true;

    private static native Class<?> findClassInternal(String var0);

    public static Class<?> findClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null");
        }
        String classNameInternal = className.replace('.', '/');
        String arrayDims = "";
        while (classNameInternal.endsWith("[]")) {
            arrayDims = arrayDims + '[';
            classNameInternal = classNameInternal.substring(0, classNameInternal.length() - 2);
        }
        return Narcissus.findClassInternal(arrayDims.isEmpty() ? classNameInternal : arrayDims + 'L' + classNameInternal + ';');
    }

    public static native void setAllowedModes(MethodHandles.Lookup var0, int var1);

    public static native void setAccessible(AccessibleObject var0, boolean var1);

    public static native Object allocateInstance(Class<?> var0);

    public static native void sneakyThrow(Throwable var0);

    public static List<Field> enumerateFields(Class<?> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Field field : Narcissus.getDeclaredFields(c)) {
                fields.add(field);
            }
        }
        return fields;
    }

    public static List<Method> enumerateMethods(Class<?> cls) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Method method : Narcissus.getDeclaredMethods(c)) {
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Constructor<?>> enumerateConstructors(Class<?> cls) {
        ArrayList constructors = new ArrayList();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Constructor<?> constructor : Narcissus.getDeclaredConstructors(c)) {
                constructors.add(constructor);
            }
        }
        return constructors;
    }

    public static Field findField(Class<?> cls, String fieldName) throws NoSuchFieldException {
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Field field : Narcissus.getDeclaredFields(c)) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static Method findMethod(Class<?> cls, String methodName, Class<?> ... paramTypes) throws NoSuchMethodException {
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Method method : Narcissus.getDeclaredMethods(c)) {
                if (!method.getName().equals(methodName) || !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static native Method[] getDeclaredMethods(Class<?> var0);

    public static native <T> Constructor<T>[] getDeclaredConstructors(Class<T> var0);

    public static native Field[] getDeclaredFields(Class<?> var0);

    public static native int getIntField(Object var0, Field var1);

    public static native long getLongField(Object var0, Field var1);

    public static native short getShortField(Object var0, Field var1);

    public static native char getCharField(Object var0, Field var1);

    public static native boolean getBooleanField(Object var0, Field var1);

    public static native byte getByteField(Object var0, Field var1);

    public static native float getFloatField(Object var0, Field var1);

    public static native double getDoubleField(Object var0, Field var1);

    public static native Object getObjectField(Object var0, Field var1);

    public static Object getField(Object object, Field field) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("field is static, call getStaticField() instead");
        }
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            return Narcissus.getIntField(object, field);
        }
        if (fieldType == Long.TYPE) {
            return Narcissus.getLongField(object, field);
        }
        if (fieldType == Short.TYPE) {
            return Narcissus.getShortField(object, field);
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf(Narcissus.getCharField(object, field));
        }
        if (fieldType == Boolean.TYPE) {
            return Narcissus.getBooleanField(object, field);
        }
        if (fieldType == Byte.TYPE) {
            return Narcissus.getByteField(object, field);
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(Narcissus.getFloatField(object, field));
        }
        if (fieldType == Double.TYPE) {
            return Narcissus.getDoubleField(object, field);
        }
        return Narcissus.getObjectField(object, field);
    }

    public static native void setIntField(Object var0, Field var1, int var2);

    public static native void setLongField(Object var0, Field var1, long var2);

    public static native void setShortField(Object var0, Field var1, short var2);

    public static native void setCharField(Object var0, Field var1, char var2);

    public static native void setBooleanField(Object var0, Field var1, boolean var2);

    public static native void setByteField(Object var0, Field var1, byte var2);

    public static native void setFloatField(Object var0, Field var1, float var2);

    public static native void setDoubleField(Object var0, Field var1, double var2);

    public static native void setObjectField(Object var0, Field var1, Object var2);

    public static void setField(Object object, Field field, Object val) {
        if (object == null) {
            throw new NullPointerException("object cannot be null");
        }
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("field is static, call setStaticField() instead");
        }
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            Narcissus.setIntField(object, field, (Integer)val);
        } else if (fieldType == Long.TYPE) {
            Narcissus.setLongField(object, field, (Long)val);
        } else if (fieldType == Short.TYPE) {
            Narcissus.setShortField(object, field, (Short)val);
        } else if (fieldType == Character.TYPE) {
            Narcissus.setCharField(object, field, ((Character)val).charValue());
        } else if (fieldType == Boolean.TYPE) {
            Narcissus.setBooleanField(object, field, (Boolean)val);
        } else if (fieldType == Byte.TYPE) {
            Narcissus.setByteField(object, field, (Byte)val);
        } else if (fieldType == Float.TYPE) {
            Narcissus.setFloatField(object, field, ((Float)val).floatValue());
        } else if (fieldType == Double.TYPE) {
            Narcissus.setDoubleField(object, field, (Double)val);
        } else {
            Narcissus.setObjectField(object, field, val);
        }
    }

    public static native int getStaticIntField(Field var0);

    public static native long getStaticLongField(Field var0);

    public static native short getStaticShortField(Field var0);

    public static native char getStaticCharField(Field var0);

    public static native boolean getStaticBooleanField(Field var0);

    public static native byte getStaticByteField(Field var0);

    public static native float getStaticFloatField(Field var0);

    public static native double getStaticDoubleField(Field var0);

    public static native Object getStaticObjectField(Field var0);

    public static Object getStaticField(Field field) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("field is not static, call getField() instead");
        }
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            return Narcissus.getStaticIntField(field);
        }
        if (fieldType == Long.TYPE) {
            return Narcissus.getStaticLongField(field);
        }
        if (fieldType == Short.TYPE) {
            return Narcissus.getStaticShortField(field);
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf(Narcissus.getStaticCharField(field));
        }
        if (fieldType == Boolean.TYPE) {
            return Narcissus.getStaticBooleanField(field);
        }
        if (fieldType == Byte.TYPE) {
            return Narcissus.getStaticByteField(field);
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(Narcissus.getStaticFloatField(field));
        }
        if (fieldType == Double.TYPE) {
            return Narcissus.getStaticDoubleField(field);
        }
        return Narcissus.getStaticObjectField(field);
    }

    public static native void setStaticIntField(Field var0, int var1);

    public static native void setStaticLongField(Field var0, long var1);

    public static native void setStaticShortField(Field var0, short var1);

    public static native void setStaticCharField(Field var0, char var1);

    public static native void setStaticBooleanField(Field var0, boolean var1);

    public static native void setStaticByteField(Field var0, byte var1);

    public static native void setStaticFloatField(Field var0, float var1);

    public static native void setStaticDoubleField(Field var0, double var1);

    public static native void setStaticObjectField(Field var0, Object var1);

    public static void setStaticField(Field field, Object val) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("field is not static, call setField() instead");
        }
        Class<?> fieldType = field.getType();
        if (fieldType == Integer.TYPE) {
            Narcissus.setStaticIntField(field, (Integer)val);
        } else if (fieldType == Long.TYPE) {
            Narcissus.setStaticLongField(field, (Long)val);
        } else if (fieldType == Short.TYPE) {
            Narcissus.setStaticShortField(field, (Short)val);
        } else if (fieldType == Character.TYPE) {
            Narcissus.setStaticCharField(field, ((Character)val).charValue());
        } else if (fieldType == Boolean.TYPE) {
            Narcissus.setStaticBooleanField(field, (Boolean)val);
        } else if (fieldType == Byte.TYPE) {
            Narcissus.setStaticByteField(field, (Byte)val);
        } else if (fieldType == Float.TYPE) {
            Narcissus.setStaticFloatField(field, ((Float)val).floatValue());
        } else if (fieldType == Double.TYPE) {
            Narcissus.setStaticDoubleField(field, (Double)val);
        } else {
            Narcissus.setStaticObjectField(field, val);
        }
    }

    public static native void invokeVoidMethod(Object var0, Method var1, Object ... var2);

    public static native int invokeIntMethod(Object var0, Method var1, Object ... var2);

    public static native long invokeLongMethod(Object var0, Method var1, Object ... var2);

    public static native short invokeShortMethod(Object var0, Method var1, Object ... var2);

    public static native char invokeCharMethod(Object var0, Method var1, Object ... var2);

    public static native boolean invokeBooleanMethod(Object var0, Method var1, Object ... var2);

    public static native byte invokeByteMethod(Object var0, Method var1, Object ... var2);

    public static native float invokeFloatMethod(Object var0, Method var1, Object ... var2);

    public static native double invokeDoubleMethod(Object var0, Method var1, Object ... var2);

    public static native Object invokeObjectMethod(Object var0, Method var1, Object ... var2);

    public static Object invokeMethod(Object object, Method method, Object ... args) {
        if (object == null) {
            throw new NullPointerException("object cannot be null");
        }
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("method is static, call invokeStaticMethod() instead");
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            Narcissus.invokeVoidMethod(object, method, args);
            return null;
        }
        if (returnType == Integer.TYPE) {
            return Narcissus.invokeIntMethod(object, method, args);
        }
        if (returnType == Long.TYPE) {
            return Narcissus.invokeLongMethod(object, method, args);
        }
        if (returnType == Short.TYPE) {
            return Narcissus.invokeShortMethod(object, method, args);
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf(Narcissus.invokeCharMethod(object, method, args));
        }
        if (returnType == Boolean.TYPE) {
            return Narcissus.invokeBooleanMethod(object, method, args);
        }
        if (returnType == Byte.TYPE) {
            return Narcissus.invokeByteMethod(object, method, args);
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(Narcissus.invokeFloatMethod(object, method, args));
        }
        if (returnType == Double.TYPE) {
            return Narcissus.invokeDoubleMethod(object, method, args);
        }
        return Narcissus.invokeObjectMethod(object, method, args);
    }

    public static native void invokeStaticVoidMethod(Method var0, Object ... var1);

    public static native int invokeStaticIntMethod(Method var0, Object ... var1);

    public static native long invokeStaticLongMethod(Method var0, Object ... var1);

    public static native short invokeStaticShortMethod(Method var0, Object ... var1);

    public static native char invokeStaticCharMethod(Method var0, Object ... var1);

    public static native boolean invokeStaticBooleanMethod(Method var0, Object ... var1);

    public static native byte invokeStaticByteMethod(Method var0, Object ... var1);

    public static native float invokeStaticFloatMethod(Method var0, Object ... var1);

    public static native double invokeStaticDoubleMethod(Method var0, Object ... var1);

    public static native Object invokeStaticObjectMethod(Method var0, Object ... var1);

    public static Object invokeStaticMethod(Method method, Object ... args) {
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("method is not static, call invokeMethod() instead");
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            Narcissus.invokeStaticVoidMethod(method, args);
            return null;
        }
        if (returnType == Integer.TYPE) {
            return Narcissus.invokeStaticIntMethod(method, args);
        }
        if (returnType == Long.TYPE) {
            return Narcissus.invokeStaticLongMethod(method, args);
        }
        if (returnType == Short.TYPE) {
            return Narcissus.invokeStaticShortMethod(method, args);
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf(Narcissus.invokeStaticCharMethod(method, args));
        }
        if (returnType == Boolean.TYPE) {
            return Narcissus.invokeStaticBooleanMethod(method, args);
        }
        if (returnType == Byte.TYPE) {
            return Narcissus.invokeStaticByteMethod(method, args);
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(Narcissus.invokeStaticFloatMethod(method, args));
        }
        if (returnType == Double.TYPE) {
            return Narcissus.invokeStaticDoubleMethod(method, args);
        }
        return Narcissus.invokeStaticObjectMethod(method, args);
    }

    static {
        boolean loaded = false;
        try {
            String libraryResourceSuffix;
            String libraryResourcePrefix = "lib/libnarcissus";
            switch (LibraryLoader.OS) {
                case Linux: {
                    libraryResourceSuffix = "-linux-" + LibraryLoader.archBits + ".so";
                    break;
                }
                case MacOSX: {
                    libraryResourceSuffix = "-macos-" + LibraryLoader.archBits + ".dylib";
                    break;
                }
                case Windows: {
                    libraryResourceSuffix = "-win-" + LibraryLoader.archBits + ".dll";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No native library available for this operating system");
                }
            }
            LibraryLoader.loadLibraryFromJar("lib/libnarcissus" + libraryResourceSuffix);
            loaded = true;
        }
        catch (Throwable t) {
            System.err.println("Could not load Narcissus native library: " + t.getMessage());
        }
        libraryLoaded = loaded;
    }
}

