/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.plain;

import hive.org.apache.parquet.bytes.ByteBufferAllocator;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import hive.org.apache.parquet.bytes.LittleEndianDataOutputStream;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.values.ValuesWriter;
import hive.org.apache.parquet.io.ParquetEncodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainValuesWriter
extends ValuesWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PlainValuesWriter.class);
    @Deprecated
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;

    public PlainValuesWriter(int initialSize, int pageSize, ByteBufferAllocator allocator) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize, allocator);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        try {
            this.out.writeInt(v.length());
            v.writeTo(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", e);
        }
    }

    @Override
    public final void writeInteger(int v) {
        try {
            this.out.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write int", e);
        }
    }

    @Override
    public final void writeLong(long v) {
        try {
            this.out.writeLong(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write long", e);
        }
    }

    @Override
    public final void writeFloat(float v) {
        try {
            this.out.writeFloat(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write float", e);
        }
    }

    @Override
    public final void writeDouble(double v) {
        try {
            this.out.writeDouble(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write double", e);
        }
    }

    @Override
    public void writeByte(int value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write byte", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing a buffer of size {}", (Object)this.arrayOut.size());
        }
        return BytesInput.from(this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public void close() {
        this.arrayOut.close();
        this.out.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(prefix + " PLAIN");
    }
}

