/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import hive.org.apache.parquet.hadoop.NoneIndexCache;
import hive.org.apache.parquet.hadoop.ParquetFileReader;
import hive.org.apache.parquet.hadoop.PrefetchIndexCache;
import hive.org.apache.parquet.hadoop.metadata.BlockMetaData;
import hive.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import hive.org.apache.parquet.hadoop.metadata.ColumnPath;
import hive.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import hive.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import java.io.IOException;
import java.util.Set;

public interface IndexCache {
    public static IndexCache create(ParquetFileReader fileReader, Set<ColumnPath> columns, CacheStrategy cacheStrategy, boolean freeCacheAfterGet) {
        if (cacheStrategy == CacheStrategy.NONE) {
            return new NoneIndexCache(fileReader);
        }
        if (cacheStrategy == CacheStrategy.PREFETCH_BLOCK) {
            return new PrefetchIndexCache(fileReader, columns, freeCacheAfterGet);
        }
        throw new UnsupportedOperationException("Unknown cache strategy: " + (Object)((Object)cacheStrategy));
    }

    public void setBlockMetadata(BlockMetaData var1) throws IOException;

    public ColumnIndex getColumnIndex(ColumnChunkMetaData var1) throws IOException;

    public OffsetIndex getOffsetIndex(ColumnChunkMetaData var1) throws IOException;

    public BloomFilter getBloomFilter(ColumnChunkMetaData var1) throws IOException;

    public void clean();

    public static enum CacheStrategy {
        NONE,
        PREFETCH_BLOCK;

    }
}

