/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.metadata;

import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.EncodingStats;
import hive.org.apache.parquet.column.statistics.SizeStatistics;
import hive.org.apache.parquet.column.statistics.Statistics;
import hive.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import hive.org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import hive.org.apache.parquet.hadoop.metadata.ColumnPath;
import hive.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import hive.org.apache.parquet.schema.PrimitiveType;
import java.util.Set;

class IntColumnChunkMetaData
extends ColumnChunkMetaData {
    private final int firstDataPage;
    private final int dictionaryPageOffset;
    private final int valueCount;
    private final int totalSize;
    private final int totalUncompressedSize;
    private final Statistics statistics;
    private final SizeStatistics sizeStatistics;

    IntColumnChunkMetaData(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize, SizeStatistics sizeStatistics) {
        super(encodingStats, ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPage = this.positiveLongToInt(firstDataPage);
        this.dictionaryPageOffset = this.positiveLongToInt(dictionaryPageOffset);
        this.valueCount = this.positiveLongToInt(valueCount);
        this.totalSize = this.positiveLongToInt(totalSize);
        this.totalUncompressedSize = this.positiveLongToInt(totalUncompressedSize);
        this.statistics = statistics;
        this.sizeStatistics = sizeStatistics;
    }

    private int positiveLongToInt(long value) {
        if (!ColumnChunkMetaData.positiveLongFitsInAnInt(value)) {
            throw new IllegalArgumentException("value should be positive and fit in an int: " + value);
        }
        return (int)(value + Integer.MIN_VALUE);
    }

    private long intToPositiveLong(int value) {
        return (long)value - Integer.MIN_VALUE;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.intToPositiveLong(this.firstDataPage);
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.intToPositiveLong(this.dictionaryPageOffset);
    }

    @Override
    public long getValueCount() {
        return this.intToPositiveLong(this.valueCount);
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.intToPositiveLong(this.totalUncompressedSize);
    }

    @Override
    public long getTotalSize() {
        return this.intToPositiveLong(this.totalSize);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public SizeStatistics getSizeStatistics() {
        return this.sizeStatistics;
    }
}

