/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.schema;

import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.io.InvalidRecordException;
import hive.org.apache.parquet.schema.GroupType;
import hive.org.apache.parquet.schema.PrimitiveType;
import hive.org.apache.parquet.schema.Type;
import hive.org.apache.parquet.schema.TypeConverter;
import hive.org.apache.parquet.schema.TypeVisitor;
import java.util.ArrayList;
import java.util.List;

public final class MessageType
extends GroupType {
    public MessageType(String name, Type ... fields) {
        super(Type.Repetition.REPEATED, name, fields);
    }

    public MessageType(String name, List<Type> fields) {
        super(Type.Repetition.REPEATED, name, fields);
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append("message ").append(this.getName()).append(this.getLogicalTypeAnnotation() == null ? "" : " (" + this.getLogicalTypeAnnotation().toString() + ")").append(" {\n");
        this.membersDisplayString(sb, "  ");
        sb.append("}\n");
    }

    public int getMaxRepetitionLevel(String ... path) {
        return this.getMaxRepetitionLevel(path, 0) - 1;
    }

    public int getMaxDefinitionLevel(String ... path) {
        return this.getMaxDefinitionLevel(path, 0) - 1;
    }

    public Type getType(String ... path) {
        return this.getType(path, 0);
    }

    public ColumnDescriptor getColumnDescription(String[] path) {
        int maxRep = this.getMaxRepetitionLevel(path);
        int maxDef = this.getMaxDefinitionLevel(path);
        PrimitiveType type = this.getType(path).asPrimitiveType();
        return new ColumnDescriptor(path, type, maxRep, maxDef);
    }

    public List<String[]> getPaths() {
        return this.getPaths(0);
    }

    public List<ColumnDescriptor> getColumns() {
        List<String[]> paths = this.getPaths(0);
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>(paths.size());
        for (String[] path : paths) {
            PrimitiveType primitiveType = this.getType(path).asPrimitiveType();
            columns.add(new ColumnDescriptor(path, primitiveType, this.getMaxRepetitionLevel(path), this.getMaxDefinitionLevel(path)));
        }
        return columns;
    }

    @Override
    public void checkContains(Type subType) {
        if (!(subType instanceof MessageType)) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        this.checkGroupContains(subType);
    }

    public <T> T convertWith(TypeConverter<T> converter) {
        ArrayList<GroupType> path = new ArrayList<GroupType>();
        path.add(this);
        return converter.convertMessageType(this, this.convertChildren(path, converter));
    }

    public boolean containsPath(String[] path) {
        return this.containsPath(path, 0);
    }

    public MessageType union(MessageType toMerge) {
        return this.union(toMerge, true);
    }

    public MessageType union(MessageType toMerge, boolean strict) {
        return new MessageType(this.getName(), this.mergeFields(toMerge, strict));
    }
}

