/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.net.openhft.hashing;

import hive.shaded.parquet.net.openhft.hashing.Access;
import hive.shaded.parquet.net.openhft.hashing.CompactLatin1CharSequenceAccess;
import hive.shaded.parquet.net.openhft.hashing.LongHashFunction;
import hive.shaded.parquet.net.openhft.hashing.LongTupleHashFunction;
import hive.shaded.parquet.net.openhft.hashing.StringHash;
import hive.shaded.parquet.net.openhft.hashing.UnsafeAccess;
import hive.shaded.parquet.net.openhft.hashing.Util;
import java.lang.reflect.Field;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
enum ModernCompactStringHash implements StringHash
{
    INSTANCE;

    private static final long valueOffset;
    private static final boolean enableCompactStrings;
    private static final Access<byte[]> compactLatin1Access;

    @Override
    public long longHash(String s, LongHashFunction hashFunction, int off, int len) {
        int sl = s.length();
        if (len <= 0 || sl <= 0) {
            Util.checkArrayOffs(sl, off, len);
            return hashFunction.hashVoid();
        }
        byte[] value = (byte[])UnsafeAccess.UNSAFE.getObject(s, valueOffset);
        if (enableCompactStrings && sl == value.length) {
            Util.checkArrayOffs(sl, off, len);
            return hashFunction.hash(value, compactLatin1Access, (long)off * 2L, (long)len * 2L);
        }
        return hashFunction.hashBytes(value, off * 2, len * 2);
    }

    @Override
    public void hash(String s, LongTupleHashFunction hashFunction, int off, int len, long[] result) {
        int sl = s.length();
        if (len <= 0 || sl <= 0) {
            Util.checkArrayOffs(sl, off, len);
            hashFunction.hashVoid(result);
        } else {
            byte[] value = (byte[])UnsafeAccess.UNSAFE.getObject(s, valueOffset);
            if (enableCompactStrings && sl == value.length) {
                Util.checkArrayOffs(sl, off, len);
                hashFunction.hash(value, compactLatin1Access, (long)off * 2L, (long)len * 2L, result);
            } else {
                hashFunction.hashBytes(value, off * 2, len * 2, result);
            }
        }
    }

    static {
        compactLatin1Access = CompactLatin1CharSequenceAccess.INSTANCE;
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = UnsafeAccess.UNSAFE.objectFieldOffset(valueField);
            byte[] value = (byte[])UnsafeAccess.UNSAFE.getObject("A", valueOffset);
            enableCompactStrings = 1 == value.length;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

