/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import hive.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.messaging.AlterCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONAlterCatalogMessage
extends AlterCatalogMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String catObjBeforeJson;
    @JsonProperty
    String catObjAfterJson;
    @JsonProperty
    Long timestamp;

    public JSONAlterCatalogMessage() {
    }

    public JSONAlterCatalogMessage(String server, String servicePrincipal, Catalog catObjBefore, Catalog catObjAfter, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        try {
            this.catObjBeforeJson = JSONMessageFactory.createCatalogObjJson(catObjBefore);
            this.catObjAfterJson = JSONMessageFactory.createCatalogObjJson(catObjAfter);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getDB() {
        return null;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Catalog getCatObjBefore() throws Exception {
        return (Catalog)JSONMessageFactory.getTObj(this.catObjBeforeJson, Catalog.class);
    }

    @Override
    public Catalog getCatObjAfter() throws Exception {
        return (Catalog)JSONMessageFactory.getTObj(this.catObjAfterJson, Catalog.class);
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

