/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import hive.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;

public class FSDatabaseEvent
implements DatabaseEvent {
    private final Path dbMetadataFile;
    private final FileSystem fileSystem;

    FSDatabaseEvent(HiveConf hiveConf, String dbDumpDirectory) {
        try {
            this.dbMetadataFile = new Path(dbDumpDirectory, "_metadata");
            this.fileSystem = this.dbMetadataFile.getFileSystem((Configuration)hiveConf);
        }
        catch (Exception e) {
            String message = "Error while identifying the filesystem for db metadata file in " + dbDumpDirectory;
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public Database dbInMetadata(String dbNameToOverride) throws SemanticException {
        try {
            MetaData rv = EximUtil.readMetaData(this.fileSystem, this.dbMetadataFile);
            Database dbObj = rv.getDatabase();
            if (dbObj == null) {
                throw new IllegalArgumentException("_metadata file read did not contain a db object - invalid dump.");
            }
            if (StringUtils.isNotBlank(dbNameToOverride)) {
                dbObj.setName(dbNameToOverride);
            }
            return dbObj;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public DatabaseEvent.State toState() {
        return new FSDBState(this.dbMetadataFile.getParent().toString());
    }

    @Override
    public BootstrapEvent.EventType eventType() {
        return BootstrapEvent.EventType.Database;
    }

    static class FSDBState
    implements DatabaseEvent.State {
        final String dbDumpDirectory;

        FSDBState(String dbDumpDirectory) {
            this.dbDumpDirectory = dbDumpDirectory;
        }

        @Override
        public DatabaseEvent toEvent(HiveConf hiveConf) {
            return new FSDatabaseEvent(hiveConf, this.dbDumpDirectory);
        }
    }
}

