/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMYarnFacade;
import org.apache.drill.yarn.appMaster.YarnFacadeException;
import org.apache.drill.yarn.core.ContainerRequestSpec;
import org.apache.drill.yarn.core.LaunchSpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class AMYarnFacadeImpl
implements AMYarnFacade {
    private static final Log LOG = LogFactory.getLog(AMYarnFacadeImpl.class);
    private YarnConfiguration conf;
    private AMRMClientAsync<AMRMClient.ContainerRequest> resourceMgr;
    private NMClientAsync nodeMgr;
    private RegisterApplicationMasterResponse registration;
    private YarnClient client;
    private int pollPeriodMs;
    private String appMasterTrackingUrl;
    private ApplicationId appId;
    private ApplicationReport appReport;
    private String amHost;
    private boolean supportsDisks;

    public AMYarnFacadeImpl(int pollPeriodMs) {
        this.pollPeriodMs = pollPeriodMs;
    }

    @Override
    public void start(AMRMClientAsync.CallbackHandler resourceCallback, NMClientAsync.CallbackHandler nodeCallback) {
        this.conf = new YarnConfiguration();
        this.resourceMgr = AMRMClientAsync.createAMRMClientAsync((int)this.pollPeriodMs, (AMRMClientAsync.CallbackHandler)resourceCallback);
        this.resourceMgr.init((Configuration)this.conf);
        this.resourceMgr.start();
        this.nodeMgr = NMClientAsync.createNMClientAsync((NMClientAsync.CallbackHandler)nodeCallback);
        this.nodeMgr.init((Configuration)this.conf);
        this.nodeMgr.start();
        this.client = YarnClient.createYarnClient();
        this.client.init((Configuration)this.conf);
        this.client.start();
        String appIdStr = System.getenv("DRILL_AM_APP_ID");
        if (appIdStr != null) {
            this.appId = ConverterUtils.toApplicationId((String)appIdStr);
            try {
                this.appReport = this.client.getApplicationReport(this.appId);
            }
            catch (IOException | YarnException e) {
                LOG.error((Object)("Failed to get YARN applicaiton report for App ID: " + appIdStr), e);
            }
        }
    }

    @Override
    public void register(String trackingUrl) throws YarnFacadeException {
        String thisHostName = NetUtils.getHostname();
        LOG.debug((Object)("Host Name from YARN: " + thisHostName));
        if (trackingUrl != null) {
            String[] names = thisHostName.split("/");
            this.amHost = names[names.length - 1];
            this.appMasterTrackingUrl = trackingUrl.replace("<host>", this.amHost);
            LOG.info((Object)("Tracking URL: " + this.appMasterTrackingUrl));
        }
        try {
            LOG.trace((Object)"Registering with YARN");
            this.registration = this.resourceMgr.registerApplicationMaster(thisHostName, 0, this.appMasterTrackingUrl);
        }
        catch (IOException | YarnException e) {
            throw new YarnFacadeException("Register AM failed", (Exception)e);
        }
        for (YarnServiceProtos.SchedulerResourceTypes type : this.registration.getSchedulerResourceTypes()) {
            if (!type.name().equals("DISK")) continue;
            this.supportsDisks = true;
        }
    }

    @Override
    public String getTrackingUrl() {
        return this.appMasterTrackingUrl;
    }

    @Override
    public boolean supportsDiskResource() {
        return this.supportsDisks;
    }

    @Override
    public AMRMClient.ContainerRequest requestContainer(ContainerRequestSpec containerSpec) {
        AMRMClient.ContainerRequest request = containerSpec.makeRequest();
        this.resourceMgr.addContainerRequest(containerSpec.makeRequest());
        return request;
    }

    @Override
    public void launchContainer(Container container, LaunchSpec taskSpec) throws YarnFacadeException {
        ContainerLaunchContext context = this.createLaunchContext(taskSpec);
        this.startContainerAsync(container, context);
    }

    private ContainerLaunchContext createLaunchContext(LaunchSpec task) throws YarnFacadeException {
        try {
            return task.createLaunchContext(this.conf);
        }
        catch (IOException e) {
            throw new YarnFacadeException("Failed to create launch context", e);
        }
    }

    private void startContainerAsync(Container container, ContainerLaunchContext context) {
        this.nodeMgr.startContainerAsync(container, context);
    }

    @Override
    public void finish(boolean succeeded, String msg) throws YarnFacadeException {
        this.nodeMgr.stop();
        String appMsg = "Drill Cluster Shut-Down";
        FinalApplicationStatus status = FinalApplicationStatus.SUCCEEDED;
        if (!succeeded) {
            appMsg = "Drill Cluster Fatal Error - check logs";
            status = FinalApplicationStatus.FAILED;
        }
        if (msg != null) {
            appMsg = msg;
        }
        try {
            this.resourceMgr.unregisterApplicationMaster(status, appMsg, "");
        }
        catch (IOException | YarnException e) {
            throw new YarnFacadeException("Deregister AM failed", (Exception)e);
        }
        this.resourceMgr.stop();
    }

    @Override
    public void releaseContainer(Container container) {
        this.resourceMgr.releaseAssignedContainer(container.getId());
    }

    @Override
    public void killContainer(Container container) {
        this.nodeMgr.stopContainerAsync(container.getId(), container.getNodeId());
    }

    @Override
    public int getNodeCount() {
        return this.resourceMgr.getClusterNodeCount();
    }

    @Override
    public Resource getResources() {
        return this.resourceMgr.getAvailableResources();
    }

    @Override
    public void removeContainerRequest(AMRMClient.ContainerRequest containerRequest) {
        this.resourceMgr.removeContainerRequest(containerRequest);
    }

    @Override
    public RegisterApplicationMasterResponse getRegistrationResponse() {
        return this.registration;
    }

    @Override
    public void blacklistNode(String nodeName) {
        this.resourceMgr.updateBlacklist(Collections.singletonList(nodeName), null);
    }

    @Override
    public void removeBlacklist(String nodeName) {
        this.resourceMgr.updateBlacklist(null, Collections.singletonList(nodeName));
    }

    @Override
    public List<NodeReport> getNodeReports() throws YarnFacadeException {
        try {
            return this.client.getNodeReports(new NodeState[]{NodeState.RUNNING});
        }
        catch (Exception e) {
            throw new YarnFacadeException("getNodeReports failed", e);
        }
    }

    @Override
    public AMYarnFacade.YarnAppHostReport getAppHostReport() {
        AMYarnFacade.YarnAppHostReport hostRpt = new AMYarnFacade.YarnAppHostReport();
        hostRpt.amHost = this.amHost;
        if (this.appId != null) {
            hostRpt.appId = this.appId.toString();
        }
        if (this.appReport == null) {
            return hostRpt;
        }
        try {
            String rmLink = this.appReport.getTrackingUrl();
            URL url = new URL(rmLink);
            hostRpt.rmHost = url.getHost();
            hostRpt.rmUrl = "http://" + hostRpt.rmHost + ":" + url.getPort() + "/";
            hostRpt.rmAppUrl = hostRpt.rmUrl + "cluster/app/" + this.appId.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
        hostRpt.nmHost = System.getenv("NM_HOST");
        String nmPort = System.getenv("NM_HTTP_PORT");
        if (hostRpt.nmHost != null || nmPort != null) {
            hostRpt.nmUrl = "http://" + hostRpt.nmHost + ":" + nmPort + "/";
            hostRpt.nmAppUrl = hostRpt.nmUrl + "node/application/" + hostRpt.appId;
        }
        return hostRpt;
    }
}

