/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.yarn.appMaster.Scheduler;
import org.apache.drill.yarn.appMaster.SchedulerStateImpl;
import org.apache.drill.yarn.appMaster.TaskSpec;
import org.apache.drill.yarn.appMaster.TaskState;
import org.apache.drill.yarn.core.ContainerRequestSpec;
import org.apache.drill.yarn.core.LaunchSpec;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;

public class Task {
    public static final long MAX_CANCELLATION_TIME = 10000L;
    private static volatile int taskCounter = 0;
    public final int taskId;
    public final Scheduler scheduler;
    public TaskSpec taskSpec;
    public SchedulerStateImpl taskGroup;
    protected TrackingState trackingState;
    public AMRMClient.ContainerRequest containerRequest;
    public Container container;
    protected TaskState state;
    protected boolean cancelled;
    public Disposition disposition;
    public Throwable error;
    public int tryCount;
    public ContainerStatus completionStatus;
    public long launchTime;
    public long stateStartTime;
    public long completionTime;
    long cancellationTime;
    public Map<String, Object> properties = new HashMap<String, Object>();

    public Task(Scheduler scheduler, TaskSpec taskSpec) {
        this.taskId = ++taskCounter;
        this.scheduler = scheduler;
        this.taskSpec = taskSpec;
        this.state = TaskState.START;
        this.resetTrackingState();
    }

    private Task(Task task) {
        this.taskId = task.taskId;
        this.scheduler = task.scheduler;
        this.taskSpec = task.taskSpec;
        this.taskGroup = task.taskGroup;
        this.trackingState = task.trackingState;
        this.containerRequest = task.containerRequest;
        this.container = task.container;
        this.state = task.state;
        this.cancelled = task.cancelled;
        this.disposition = task.disposition;
        this.error = task.error;
        this.tryCount = task.tryCount;
        this.completionStatus = task.completionStatus;
        this.launchTime = task.launchTime;
        this.stateStartTime = task.stateStartTime;
        this.completionTime = task.completionTime;
        this.cancellationTime = task.cancellationTime;
        this.properties.putAll(task.properties);
    }

    public void resetTrackingState() {
        this.trackingState = this.scheduler.isTracked() ? TrackingState.NEW : TrackingState.UNTRACKED;
    }

    public int getId() {
        return this.taskId;
    }

    public ContainerRequestSpec getContainerSpec() {
        return this.taskSpec.containerSpec;
    }

    public LaunchSpec getLaunchSpec() {
        return this.taskSpec.launchSpec;
    }

    public TaskState getState() {
        return this.state;
    }

    public ContainerId getContainerId() {
        assert (this.container != null);
        return this.container.getId();
    }

    public Container getContainer() {
        assert (this.container != null);
        return this.container;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public boolean isFailed() {
        return this.disposition != null && this.disposition != Disposition.COMPLETED;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    public SchedulerStateImpl getGroup() {
        return this.taskGroup;
    }

    public void setGroup(SchedulerStateImpl taskGroup) {
        this.taskGroup = taskGroup;
    }

    public boolean retryable() {
        return !this.cancelled && this.disposition != Disposition.COMPLETED;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void reset() {
        assert (!this.cancelled);
        this.error = null;
        this.disposition = null;
        this.completionStatus = null;
        this.launchTime = 0L;
        this.completionTime = 0L;
        this.cancellationTime = 0L;
        this.container = null;
        this.resetTrackingState();
    }

    public long uptime() {
        long endTime = this.completionTime;
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        }
        return endTime - this.launchTime;
    }

    public String getHostName() {
        if (this.container == null) {
            return null;
        }
        return this.container.getNodeId().getHost();
    }

    public TrackingState getTrackingState() {
        return this.trackingState;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[id=").append(this.taskId).append(", type=");
        if (this.scheduler != null) {
            buf.append(this.scheduler.getName());
        }
        buf.append(", name=").append(this.getName());
        if (this.container != null) {
            buf.append(", host=").append(this.getHostName());
        }
        buf.append(", state=").append(this.state.toString()).append("]");
        return buf.toString();
    }

    public boolean isLive() {
        return this.state == TaskState.RUNNING && !this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        this.cancellationTime = System.currentTimeMillis();
    }

    public Task copy() {
        return new Task(this);
    }

    public String getName() {
        return this.taskSpec == null ? null : this.taskSpec.name;
    }

    public String getLabel() {
        return this.toString();
    }

    public void setTrackingState(TrackingState tState) {
        this.trackingState = tState;
    }

    public static enum TrackingState {
        UNTRACKED("N/A"),
        NEW("Waiting"),
        START_ACK("OK"),
        END_ACK("Deregistered");

        private String displayName;

        private TrackingState(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum Disposition {
        CANCELLED,
        LAUNCH_FAILED,
        RUN_FAILED,
        COMPLETED,
        TOO_MANY_RETRIES,
        RETRIED;

    }
}

