/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.exec.server.rest.CsrfTokenInjectFilter;
import org.apache.drill.exec.server.rest.CsrfTokenValidateFilter;
import org.apache.drill.exec.util.SecureRandomStringUtils;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.http.AMSecurityManager;
import org.apache.drill.yarn.appMaster.http.AMSecurityManagerImpl;
import org.apache.drill.yarn.appMaster.http.AmRestApi;
import org.apache.drill.yarn.appMaster.http.WebUiPageTree;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.joda.time.DateTime;

public class WebServer
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebServer.class);
    private final Server jettyServer;
    private Dispatcher dispatcher;

    public WebServer(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        Config config = DrillOnYarnConfig.config();
        this.jettyServer = config.getBoolean(DrillOnYarnConfig.HTTP_ENABLED) ? new Server() : null;
    }

    public void start() throws Exception {
        if (this.jettyServer == null) {
            return;
        }
        this.build();
        this.jettyServer.start();
    }

    private void build() throws Exception {
        Config config = DrillOnYarnConfig.config();
        this.buildConnector(config);
        this.buildServlets(config);
    }

    private void buildConnector(Config config) throws Exception {
        ServerConnector serverConnector = config.getBoolean(DrillOnYarnConfig.HTTP_ENABLE_SSL) ? this.createHttpsConnector(config) : this.createHttpConnector(config);
        this.jettyServer.addConnector((Connector)serverConnector);
    }

    private void buildServlets(Config config) {
        ServletContextHandler servletContextHandler = new ServletContextHandler(null, "/");
        servletContextHandler.setErrorHandler(this.createErrorHandler());
        this.jettyServer.setHandler((Handler)servletContextHandler);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new WebUiPageTree(this.dispatcher)));
        servletHolder.setInitOrder(1);
        servletContextHandler.addServlet(servletHolder, "/*");
        ServletHolder restHolder = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new AmRestApi(this.dispatcher)));
        restHolder.setInitOrder(2);
        servletContextHandler.addServlet(restHolder, "/rest/*");
        servletContextHandler.addFilter(CsrfTokenInjectFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        for (String path : new String[]{"/resize", "/stop", "/cancel"}) {
            servletContextHandler.addFilter(CsrfTokenValidateFilter.class, path, EnumSet.of(DispatcherType.REQUEST));
        }
        this.setupStaticResources(servletContextHandler);
        if (AMSecurityManagerImpl.isEnabled()) {
            servletContextHandler.setSecurityHandler((SecurityHandler)this.createSecurityHandler());
            servletContextHandler.setSessionHandler(this.createSessionHandler(config, servletContextHandler.getSecurityHandler()));
        }
    }

    private ErrorHandler createErrorHandler() {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setShowMessageInTitle(true);
        return errorHandler;
    }

    private void setupStaticResources(ServletContextHandler servletContextHandler) {
        ServletHolder staticHolder = new ServletHolder("static", DefaultServlet.class);
        staticHolder.setInitParameter("resourceBase", Resource.newClassPathResource((String)"/rest/static").toString());
        staticHolder.setInitParameter("dirAllowed", "false");
        staticHolder.setInitParameter("pathInfoOnly", "true");
        servletContextHandler.addServlet(staticHolder, "/static/*");
        ServletHolder amStaticHolder = new ServletHolder("am-static", DefaultServlet.class);
        amStaticHolder.setInitParameter("resourceBase", Resource.newClassPathResource((String)"/drill-am/static").toString());
        amStaticHolder.setInitParameter("dirAllowed", "false");
        amStaticHolder.setInitParameter("pathInfoOnly", "true");
        servletContextHandler.addServlet(amStaticHolder, "/drill-am/static/*");
    }

    private ConstraintSecurityHandler createSecurityHandler() {
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        ImmutableSet knownRoles = ImmutableSet.of((Object)"admin");
        security.setConstraintMappings(Collections.emptyList(), (Set)knownRoles);
        security.setAuthenticator((Authenticator)new FormAuthenticator("/login", "/login", true));
        security.setLoginService((LoginService)new AmLoginService(AMSecurityManagerImpl.instance()));
        return security;
    }

    private SessionHandler createSessionHandler(Config config, final SecurityHandler securityHandler) {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setMaxInactiveInterval(config.getInt(DrillOnYarnConfig.HTTP_SESSION_MAX_IDLE_SECS));
        sessionHandler.addEventListener((EventListener)new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent se) {
            }

            public void sessionDestroyed(HttpSessionEvent se) {
                HttpSession session = se.getSession();
                if (session == null) {
                    return;
                }
                Object authCreds = session.getAttribute("org.eclipse.jetty.security.UserIdentity");
                if (authCreds != null) {
                    SessionAuthentication sessionAuth = (SessionAuthentication)authCreds;
                    securityHandler.logout((Authentication.User)sessionAuth);
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                }
            }
        });
        return sessionHandler;
    }

    private ServerConnector createHttpConnector(Config config) {
        LOG.info((Object)"Setting up HTTP connector for web server");
        ServerConnector httpConnector = new ServerConnector(this.jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(this.baseHttpConfig())});
        httpConnector.setPort(config.getInt(DrillOnYarnConfig.HTTP_PORT));
        return httpConnector;
    }

    private ServerConnector createHttpsConnector(Config config) throws Exception {
        LOG.info((Object)"Setting up HTTPS connector for web server");
        SslContextFactory sslContextFactory = new SslContextFactory();
        LOG.info((Object)"Using generated self-signed SSL settings for web server");
        SecureRandom random = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        DateTime now = DateTime.now();
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.OU, "Apache Drill (auth-generated)").addRDN(BCStyle.O, "Apache Software Foundation (auto-generated)").addRDN(BCStyle.CN, "Drill AM");
        Date notBefore = now.minusMinutes(1).toDate();
        Date notAfter = now.plusYears(5).toDate();
        BigInteger serialNumber = new BigInteger(128, random);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
        certificate.checkValidity(now.toDate());
        certificate.verify(certificate.getPublicKey());
        String keyStorePasswd = SecureRandomStringUtils.random((int)20);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry("DrillAutoGeneratedCert", keyPair.getPrivate(), keyStorePasswd.toCharArray(), new Certificate[]{certificate});
        sslContextFactory.setKeyStore(keyStore);
        sslContextFactory.setKeyStorePassword(keyStorePasswd);
        HttpConfiguration httpsConfig = this.baseHttpConfig();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(this.jettyServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(config.getInt(DrillOnYarnConfig.HTTP_PORT));
        return sslConnector;
    }

    private HttpConfiguration baseHttpConfig() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        return httpConfig;
    }

    @Override
    public void close() throws Exception {
        if (this.jettyServer != null) {
            this.jettyServer.stop();
        }
    }

    public static class AmLoginService
    implements LoginService {
        private final AMSecurityManager securityMgr;
        protected IdentityService identityService = new DefaultIdentityService();

        public AmLoginService(AMSecurityManager securityMgr) {
            this.securityMgr = securityMgr;
        }

        public String getName() {
            return "drill-am";
        }

        public UserIdentity login(String username, Object credentials, ServletRequest request) {
            if (!this.securityMgr.login(username, (String)credentials)) {
                return null;
            }
            return new DefaultUserIdentity(null, (Principal)new AMUserPrincipal(username), new String[]{"admin"});
        }

        public boolean validate(UserIdentity user) {
            return true;
        }

        public IdentityService getIdentityService() {
            return this.identityService;
        }

        public void setIdentityService(IdentityService service) {
            this.identityService = service;
        }

        public void logout(UserIdentity user) {
        }
    }

    public static class AMUserPrincipal
    implements Principal {
        private final String userName;

        public AMUserPrincipal(String userName) {
            this.userName = userName;
        }

        @Override
        public String getName() {
            return this.userName;
        }
    }
}

