/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.zk;

import java.nio.charset.StandardCharsets;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.drill.yarn.zk.ZKClusterCoordinator;
import org.apache.drill.yarn.zk.ZKRuntimeException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class AMRegistry {
    private static final String AM_REGISTRY = "/drill-on-yarn";
    private ZKClusterCoordinator zkCoord;
    private String amHost;
    private int amPort;
    private String amAppId;
    private String zkRoot;
    private String clusterId;

    public AMRegistry(ZKClusterCoordinator zkCoord) {
        this.zkCoord = zkCoord;
    }

    public void useLocalRegistry(String zkRoot, String clusterId) {
        this.zkRoot = zkRoot;
        this.clusterId = clusterId;
    }

    public void register(String amHost, int amPort, String amAppId) throws ZKRuntimeException {
        this.amHost = amHost;
        this.amPort = amPort;
        this.amAppId = amAppId;
        try {
            try {
                ((ACLBackgroundPathAndBytesable)this.zkCoord.getCurator().create().withMode(CreateMode.PERSISTENT)).forPath(AM_REGISTRY, new byte[0]);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            String amPath = "/drill-on-yarn/" + this.clusterId;
            String content = amHost + ":" + Integer.toString(amPort) + ":" + amAppId;
            try {
                ((ACLBackgroundPathAndBytesable)this.zkCoord.getCurator().create().withMode(CreateMode.EPHEMERAL)).forPath(amPath, content.getBytes(StandardCharsets.UTF_8));
            }
            catch (KeeperException.NodeExistsException e) {
                String packed;
                String[] unpacked;
                byte[] data = (byte[])this.zkCoord.getCurator().getData().forPath(amPath);
                Object existing = data == null ? "Unknown" : ((unpacked = (packed = new String(data, StandardCharsets.UTF_8)).split(":")).length < 3 ? packed : unpacked[0] + ", port: " + unpacked[1] + ", Application ID: " + unpacked[2]);
                throw new ZKRuntimeException("FAILED! An Application Master already exists for " + this.zkRoot + "/" + this.clusterId + " on host: " + (String)existing);
            }
        }
        catch (ZKRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZKRuntimeException("Failed to create AM registration node", e);
        }
    }
}

