/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta.read;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.delta.DeltaRowGroupScan;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.AbstractParquetScanBatchCreator;
import org.apache.drill.exec.store.parquet.ParquetScanBatchCreator;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;

public class DeltaScanBatchCreator
extends AbstractParquetScanBatchCreator
implements BatchCreator<DeltaRowGroupScan> {
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, DeltaRowGroupScan rowGroupScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        OperatorContext oContext = context.newOperatorContext((PhysicalOperator)rowGroupScan);
        return this.getBatch(context, rowGroupScan, oContext);
    }

    protected AbstractParquetScanBatchCreator.AbstractDrillFileSystemManager getDrillFileSystemCreator(OperatorContext operatorContext, OptionManager optionManager) {
        return new ParquetScanBatchCreator.ParquetDrillFileSystemManager(operatorContext, optionManager.getOption((String)"store.parquet.reader.pagereader.async").bool_val.booleanValue());
    }

    protected Map<String, String> getImplicitValues(AbstractParquetRowGroupScan rowGroupScan, ColumnExplorer columnExplorer, RowGroupReadEntry rowGroup, DrillFileSystem fs) {
        return ((DeltaRowGroupScan)rowGroupScan).getPartitions(rowGroup);
    }
}

