/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.druid.DruidGroupScan;
import org.apache.drill.exec.store.druid.DruidPushDownFilterForScan;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfig;
import org.apache.drill.exec.store.druid.druid.ScanQueryBuilder;
import org.apache.drill.exec.store.druid.rest.DruidAdminClient;
import org.apache.drill.exec.store.druid.rest.DruidQueryClient;
import org.apache.drill.exec.store.druid.rest.RestClientWrapper;
import org.apache.drill.exec.store.druid.schema.DruidSchemaFactory;

public class DruidStoragePlugin
extends AbstractStoragePlugin {
    private final DrillbitContext context;
    private final DruidStoragePluginConfig pluginConfig;
    private final DruidAdminClient druidAdminClient;
    private final DruidQueryClient druidQueryClient;
    private final DruidSchemaFactory schemaFactory;
    private final ScanQueryBuilder scanQueryBuilder;

    public DruidStoragePlugin(DruidStoragePluginConfig pluginConfig, DrillbitContext context, String name) {
        super(context, name);
        this.pluginConfig = pluginConfig;
        this.context = context;
        RestClientWrapper restClient = new RestClientWrapper();
        this.druidAdminClient = new DruidAdminClient(pluginConfig.getCoordinatorAddress(), restClient);
        this.druidQueryClient = new DruidQueryClient(pluginConfig.getBrokerAddress(), restClient);
        this.schemaFactory = new DruidSchemaFactory(this, name);
        this.scanQueryBuilder = new ScanQueryBuilder();
    }

    public DruidGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        DruidScanSpec scanSpec = (DruidScanSpec)selection.getListWith((TypeReference)new TypeReference<DruidScanSpec>(){});
        return new DruidGroupScan(userName, this, scanSpec, null, -1);
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules(OptimizerRulesContext optimizerRulesContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: {
                return ImmutableSet.of((Object)DruidPushDownFilterForScan.INSTANCE);
            }
        }
        return ImmutableSet.of();
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public boolean supportsRead() {
        return true;
    }

    public boolean supportsWrite() {
        return false;
    }

    public DruidStoragePluginConfig getConfig() {
        return this.pluginConfig;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public DruidAdminClient getAdminClient() {
        return this.druidAdminClient;
    }

    public DruidQueryClient getDruidQueryClient() {
        return this.druidQueryClient;
    }

    public ScanQueryBuilder getScanQueryBuilder() {
        return this.scanQueryBuilder;
    }
}

