/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="kafka")
public class KafkaStoragePluginConfig
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(KafkaStoragePluginConfig.class);
    public static final String NAME = "kafka";
    private final Properties kafkaConsumerProps = new Properties();

    @JsonCreator
    public KafkaStoragePluginConfig(@JsonProperty(value="kafkaConsumerProps") Map<String, String> kafkaConsumerProps) {
        this.kafkaConsumerProps.putAll(kafkaConsumerProps);
        logger.debug("Kafka Consumer Props {}", (Object)this.kafkaConsumerProps);
    }

    public Properties getKafkaConsumerProps() {
        return this.kafkaConsumerProps;
    }

    public int hashCode() {
        return Objects.hash(this.kafkaConsumerProps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KafkaStoragePluginConfig that = (KafkaStoragePluginConfig)((Object)o);
        return this.kafkaConsumerProps.equals(that.kafkaConsumerProps);
    }

    public String toString() {
        return new StringJoiner(", ", KafkaStoragePluginConfig.class.getSimpleName() + "[", "]").add("kafkaConsumerProps=" + String.valueOf(this.kafkaConsumerProps)).toString();
    }
}

