/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.decoders;

import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.avro.AvroColumnConverterFactory;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.MetaDataField;
import org.apache.drill.exec.store.kafka.ReadOptions;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroMessageReader
implements MessageReader {
    private static final Logger logger = LoggerFactory.getLogger(AvroMessageReader.class);
    private KafkaAvroDeserializer deserializer;
    private ColumnConverter converter;
    private ResultSetLoader loader;
    private boolean deserializeKey;

    @Override
    public void init(SchemaNegotiator negotiator, ReadOptions readOptions, KafkaStoragePlugin plugin) {
        Properties kafkaConsumerProps = plugin.getConfig().getKafkaConsumerProps();
        Map<String, Object> propertiesMap = kafkaConsumerProps.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
        this.deserializer = new KafkaAvroDeserializer(null, propertiesMap);
        TupleMetadata providedSchema = negotiator.providedSchema();
        this.loader = negotiator.build();
        AvroColumnConverterFactory factory = new AvroColumnConverterFactory(providedSchema);
        this.converter = factory.getRootConverter(providedSchema, (TupleMetadata)new TupleSchema(), (TupleWriter)this.loader.writer());
        String keyDeserializer = kafkaConsumerProps.getProperty("key.deserializer");
        this.deserializeKey = keyDeserializer != null && keyDeserializer.equals(KafkaAvroDeserializer.class.getName());
    }

    @Override
    public void readMessage(ConsumerRecord<?, ?> record) {
        RowSetLoader rowWriter = this.loader.writer();
        byte[] recordArray = (byte[])record.value();
        GenericRecord genericRecord = (GenericRecord)this.deserializer.deserialize(null, recordArray);
        Schema schema = genericRecord.getSchema();
        if (Schema.Type.RECORD != schema.getType()) {
            throw UserException.dataReadError().message(String.format("Root object must be record type. Found: %s", schema.getType()), new Object[0]).addContext("Reader", new Object[]{this}).build(logger);
        }
        rowWriter.start();
        this.converter.convert((Object)genericRecord);
        this.writeValue(rowWriter, MetaDataField.KAFKA_TOPIC, record.topic());
        this.writeValue(rowWriter, MetaDataField.KAFKA_PARTITION_ID, record.partition());
        this.writeValue(rowWriter, MetaDataField.KAFKA_OFFSET, record.offset());
        this.writeValue(rowWriter, MetaDataField.KAFKA_TIMESTAMP, record.timestamp());
        this.writeValue(rowWriter, MetaDataField.KAFKA_MSG_KEY, record.key() != null ? this.getKeyValue((byte[])record.key()) : null);
        rowWriter.save();
    }

    private Object getKeyValue(byte[] keyValue) {
        if (this.deserializeKey) {
            return this.deserializer.deserialize(null, keyValue).toString();
        }
        return new String(keyValue, StandardCharsets.UTF_8);
    }

    private <T> void writeValue(RowSetLoader rowWriter, MetaDataField metaDataField, T value) {
        if (rowWriter.tupleSchema().column(metaDataField.getFieldName()) == null) {
            PrimitiveColumnMetadata colSchema = MetadataUtils.newScalar((String)metaDataField.getFieldName(), (TypeProtos.MinorType)metaDataField.getFieldType(), (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
            rowWriter.addColumn((ColumnMetadata)colSchema);
        }
        rowWriter.column(metaDataField.getFieldName()).setObject(value);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> getConsumer(KafkaStoragePlugin plugin) {
        return new KafkaConsumer(plugin.getConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Override
    public ResultSetLoader getResultSetLoader() {
        return this.loader;
    }

    @Override
    public boolean endBatch() {
        return this.loader.hasRows();
    }

    @Override
    public void close() throws IOException {
        try {
            this.deserializer.close();
            this.loader.close();
        }
        catch (Exception e) {
            logger.warn("Error while closing AvroMessageReader: {}", (Object)e.getMessage());
        }
    }
}

