/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.io.DuplicatableInputStream;
import com.oracle.bmc.objectstorage.transfer.ProgressTracker;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgressTrackingInputStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressTrackingInputStreamFactory.class);

    ProgressTrackingInputStreamFactory() {
    }

    static InputStream create(InputStream source, ProgressTracker progressTracker) {
        if (progressTracker == null) {
            return source;
        }
        if (source instanceof DuplicatableInputStream) {
            return new DuplicatableProgressTrackingInputStream(source, progressTracker);
        }
        return new ProgressTrackingInputStream(source, progressTracker);
    }

    private static final class DuplicatableProgressTrackingInputStream
    extends ProgressTrackingInputStream
    implements DuplicatableInputStream {
        private DuplicatableProgressTrackingInputStream(InputStream source, ProgressTracker progressTracker) {
            super(source, progressTracker);
            if (!(source instanceof DuplicatableInputStream)) {
                throw new IllegalStateException("Source MUST be a DuplicatableInputStream");
            }
        }

        public InputStream duplicate() {
            return ProgressTrackingInputStreamFactory.create(((DuplicatableInputStream)this.getSource()).duplicate(), this.getProgressTracker().reset());
        }
    }

    private static class ProgressTrackingInputStream
    extends InputStream {
        private static final Logger LOG = LoggerFactory.getLogger(ProgressTrackingInputStream.class);
        private final InputStream source;
        @NonNull
        private final ProgressTracker progressTracker;
        private long bytesReadSinceReset = 0L;

        @Override
        public long skip(long n) throws IOException {
            return this.source.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.source.available();
        }

        @Override
        public void mark(int readlimit) {
            this.source.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.source.reset();
            this.progressTracker.invalidateBytesRead(this.bytesReadSinceReset);
            LOG.trace("Invalidated {} bytes", (Object)this.bytesReadSinceReset);
            this.bytesReadSinceReset = 0L;
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        @Override
        public int read() throws IOException {
            int data = this.source.read();
            if (data != -1) {
                this.checkAndReportBytesRead(1);
            }
            return data;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = this.source.read(b, off, len);
            this.checkAndReportBytesRead(bytesRead);
            return bytesRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int bytesRead = this.source.read(b);
            this.checkAndReportBytesRead(bytesRead);
            return bytesRead;
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        private void checkAndReportBytesRead(int bytesRead) {
            if (bytesRead != -1) {
                this.bytesReadSinceReset += (long)bytesRead;
                LOG.trace("Read {} bytes for a total of {}", (Object)bytesRead, (Object)this.bytesReadSinceReset);
                this.progressTracker.onBytesRead(bytesRead);
            }
        }

        @ConstructorProperties(value={"source", "progressTracker"})
        protected ProgressTrackingInputStream(InputStream source, @NonNull ProgressTracker progressTracker) {
            if (progressTracker == null) {
                throw new NullPointerException("progressTracker is marked non-null but is null");
            }
            this.source = source;
            this.progressTracker = progressTracker;
        }

        protected InputStream getSource() {
            return this.source;
        }

        @NonNull
        protected ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }
    }
}

