/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestByteBufferArray {
    @Test
    public void testAsSubBufferWhenEndOffsetLandInLastBuffer() throws Exception {
        int capacity = 0x400000;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size, boolean directByteBuffer) throws IOException {
                if (directByteBuffer) {
                    return ByteBuffer.allocateDirect((int)size);
                }
                return ByteBuffer.allocate((int)size);
            }
        };
        ByteBufferArray array = new ByteBufferArray((long)capacity, false, allocator);
        ByteBuff subBuf = array.asSubByteBuff(0L, capacity);
        subBuf.position(capacity - 1);
        Assert.assertTrue((boolean)subBuf.hasRemaining());
        subBuf.get();
        Assert.assertFalse((boolean)subBuf.hasRemaining());
    }

    @Test
    public void testByteBufferCreation() throws Exception {
        int capacity = 490907010;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size, boolean directByteBuffer) throws IOException {
                if (directByteBuffer) {
                    return ByteBuffer.allocateDirect((int)size);
                }
                return ByteBuffer.allocate((int)size);
            }
        };
        ByteBufferArray array = new ByteBufferArray((long)capacity, false, allocator);
        Assert.assertEquals((long)119L, (long)array.buffers.length);
        for (int i = 0; i < array.buffers.length; ++i) {
            if (i == array.buffers.length - 1) {
                Assert.assertEquals((long)array.buffers[i].capacity(), (long)0L);
                continue;
            }
            Assert.assertEquals((long)array.buffers[i].capacity(), (long)0x400000L);
        }
    }

    @Test
    public void testByteBufferCreation1() throws Exception {
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size, boolean directByteBuffer) throws IOException {
                if (directByteBuffer) {
                    return ByteBuffer.allocateDirect((int)size);
                }
                return ByteBuffer.allocate((int)size);
            }
        };
        DummyByteBufferArray array = new DummyByteBufferArray(0x700000L, false, allocator);
        array.bufferCount = 25;
        array.buffers = new ByteBuffer[array.bufferCount + 1];
        array.createBuffers(true, allocator);
        for (int i = 0; i < array.buffers.length; ++i) {
            if (i == array.buffers.length - 1) {
                Assert.assertEquals((long)array.buffers[i].capacity(), (long)0L);
                continue;
            }
            Assert.assertEquals((long)array.buffers[i].capacity(), (long)458752L);
        }
    }

    private static class DummyByteBufferArray
    extends ByteBufferArray {
        public DummyByteBufferArray(long capacity, boolean directByteBuffer, ByteBufferAllocator allocator) throws IOException {
            super(capacity, directByteBuffer, allocator);
        }

        int getThreadCount() {
            return 16;
        }
    }
}

