/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.planner.logical.ModifyTableEntry;
import org.apache.drill.exec.planner.sql.parser.SqlDropTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcInsertWriter;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapitalizingJdbcSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(CapitalizingJdbcSchema.class);
    private final Map<String, CapitalizingJdbcSchema> schemaMap = new HashMap<String, CapitalizingJdbcSchema>();
    private final JdbcSchema inner;
    private final boolean caseSensitive;
    private final JdbcStoragePlugin plugin;
    private final String catalog;
    private final String schema;

    public CapitalizingJdbcSchema(List<String> parentSchemaPath, String name, DataSource dataSource, SqlDialect dialect, DrillJdbcConvention convention, String catalog, String schema, boolean caseSensitive) {
        super(parentSchemaPath, name);
        this.inner = new JdbcSchema(dataSource, dialect, (JdbcConvention)convention, catalog, schema);
        this.caseSensitive = caseSensitive;
        this.plugin = convention.getPlugin();
        this.schema = schema;
        this.catalog = catalog;
    }

    public String getTypeName() {
        return "jdbc";
    }

    public Collection<Function> getFunctions(String name) {
        return this.inner.getFunctions(name);
    }

    public Set<String> getFunctionNames() {
        return this.inner.getFunctionNames();
    }

    public CapitalizingJdbcSchema getSubSchema(String name) {
        return this.schemaMap.get(name);
    }

    void setHolder(SchemaPlus plusOfThis) {
        for (String s : this.getSubSchemaNames()) {
            CapitalizingJdbcSchema inner = this.getSubSchema(s);
            SchemaPlus holder = plusOfThis.add(s, (Schema)inner);
            inner.setHolder(holder);
        }
    }

    public Set<String> getSubSchemaNames() {
        return this.schemaMap.keySet();
    }

    public Set<String> getTableNames() {
        if (this.isCatalogSchema()) {
            return Collections.emptySet();
        }
        return this.inner.getTableNames();
    }

    public CreateTableEntry createNewTable(final String tableName, List<String> partitionColumns, StorageStrategy strategy) {
        if (this.plugin.getConfig().isWritable() == null || !this.plugin.getConfig().isWritable().booleanValue()) {
            throw UserException.dataWriteError().message(this.plugin.getName() + " is not writable.", new Object[0]).build(logger);
        }
        return new CreateTableEntry(){

            public Writer getWriter(PhysicalOperator child) {
                return new JdbcWriter(child, CapitalizingJdbcSchema.this.getFullTablePath(tableName), CapitalizingJdbcSchema.this.inner, CapitalizingJdbcSchema.this.plugin);
            }

            public List<String> getPartitionColumns() {
                return Collections.emptyList();
            }
        };
    }

    public ModifyTableEntry modifyTable(String tableName) {
        return child -> new JdbcInsertWriter(child, this.getFullTablePath(tableName), this.inner, this.plugin);
    }

    public void dropTable(String tableName) {
        if (!this.plugin.getConfig().isWritable().booleanValue()) {
            throw UserException.dataWriteError().message(this.plugin.getName() + " is not writable.", new Object[0]).build(logger);
        }
        List<String> names = this.getFullTablePath(tableName);
        SqlCall dropCall = SqlDropTable.OPERATOR.createCall(SqlParserPos.ZERO, new SqlNode[]{new SqlIdentifier(names, SqlParserPos.ZERO), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO)});
        String dropTableQuery = dropCall.toSqlString(this.inner.dialect).getSql();
        try (Connection conn = this.inner.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            logger.debug("Executing drop table query: {}", (Object)dropTableQuery);
            int successfullyDropped = stmt.executeUpdate(dropTableQuery);
            logger.debug("Result: {}", (Object)successfullyDropped);
            if (successfullyDropped > 0) {
                throw UserException.dataWriteError().message("Error while dropping table " + tableName, new Object[0]).addContext(stmt.getWarnings().getMessage()).build(logger);
            }
        }
        catch (SQLException e) {
            throw UserException.dataWriteError((Throwable)e).message("Failure while trying to drop table '%s'.", new Object[]{tableName}).addContext("plugin", this.name).build(logger);
        }
    }

    private List<String> getFullTablePath(String tableName) {
        ArrayList<String> names = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)this.catalog)) {
            names.add(this.catalog);
        }
        if (!StringUtils.isEmpty((CharSequence)this.schema)) {
            names.add(this.schema);
        }
        names.add(tableName);
        return names;
    }

    public boolean isMutable() {
        return this.plugin.getConfig().isWritable();
    }

    public Table getTable(String name) {
        if (this.isCatalogSchema()) {
            logger.warn("Failed attempt to find table '{}' in catalog schema '{}'", (Object)name, (Object)this.getName());
            return null;
        }
        Table table = this.inner.getTable(name);
        if (table == null && !this.areTableNamesCaseSensitive() && (table = this.inner.getTable(name.toUpperCase())) == null) {
            table = this.inner.getTable(name.toLowerCase());
        }
        return table;
    }

    public boolean areTableNamesCaseSensitive() {
        return this.caseSensitive;
    }

    public CapitalizingJdbcSchema getDefaultSchema() {
        return this.isCatalogSchema() ? this.schemaMap.values().iterator().next().getDefaultSchema() : this;
    }

    private boolean isCatalogSchema() {
        return !this.schemaMap.isEmpty();
    }

    void addSubSchema(CapitalizingJdbcSchema subSchema) {
        this.schemaMap.put(subSchema.getName(), subSchema);
    }
}

